% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotsurface}
\alias{plotsurface}
\title{Creates a colored surface plot from data frame input.}
\usage{
plotsurface(data, view, predictor = NULL, valCI = NULL, main = NULL,
  xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL, zlim = NULL,
  col = NULL, color = topo.colors(50), ci.col = c("red", "green"),
  nCol = 50, add.color.legend = TRUE, dec = NULL, ...)
}
\arguments{
\item{data}{Data frame or list with plot data. A data frame needs to have a 
column with x values, a column with y values and a column with z values. A 
list contains a vector with unique x values, a vector with unique y values, 
and a matrix with z-values. The output of the function fvisgam is an 
example of a suitable list.}

\item{view}{A vector with the names or numbers of the columns to plot on 
the x axis and y axis respectively.}

\item{predictor}{Optional: the name of the column in the data frame 
\code{data} that provides the z-values. If data contains more than one 
column besides the x- and y-values, the \code{predictor} should be provided.}

\item{valCI}{Optional: the name of the column in the data frame 
\code{data} that provides the CI-values. If not NULL, CI contour lines
will be plotted.}

\item{main}{Text string, an overall title for the plot.}

\item{xlab}{Label for x axis. Default is name of first \code{view} variable.}

\item{ylab}{Label for y axis. Default is name of second \code{view} 
variable.}

\item{xlim}{x-limits for the plot.}

\item{ylim}{y-limits for the plot.}

\item{zlim}{z-limits for the plot.}

\item{col}{Color for the  contour lines and labels.}

\item{color}{a list of colors such as that generated by 
\code{\link[grDevices]{rainbow}}, \code{\link[grDevices]{heat.colors}}
\code{\link[grDevices]{colors}}, \code{\link[grDevices]{topo.colors}}, 
\code{\link[grDevices]{terrain.colors}} or similar functions.}

\item{ci.col}{Two-value vector with colors for the lower CI contour lines 
and for the upper CI contour lines.}

\item{nCol}{The number of colors to use in color schemes.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{dec}{Numeric: number of decimals for rounding the color legend. 
When NULL (default), no rounding. If -1 (default), automatically determined. 
Note: if value = -1 (default), rounding will be applied also when 
\code{zlim} is provided.}

\item{...}{Optional parameters for \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}.}
}
\description{
This function is a wrapper around \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}. See \code{vignette("plotfunctions")} 
for an example of how you could use \code{\link[graphics]{image}} and 
\code{\link[graphics]{contour}}.
}
\examples{

# From the package graphics, see help(image):
x <- 10*(1:nrow(volcano))
y <- 10*(1:ncol(volcano))
image(x, y, volcano, col = terrain.colors(100), axes = FALSE)
contour(x, y, volcano, levels = seq(90, 200, by = 5),
        add = TRUE, col = "peru")
axis(1, at = seq(100, 800, by = 100))
axis(2, at = seq(100, 600, by = 100))
box()
title(main = "Maunga Whau Volcano", font.main = 4)

# now with plot surface:
# first convert to data frame
tmp <- data.frame(value = as.vector(volcano), 
    x = 10*rep(1:nrow(volcano), ncol(volcano)), 
    y = 10*rep(1:ncol(volcano), each=nrow(volcano)))
plotsurface(tmp, view=c('x', "y"), predictor='value', main="Maunga Whau Volcano")

# or with terrain colors:
plotsurface(tmp, view=c('x', "y"), predictor='value', 
    main="Maunga Whau Volcano", color="terrain")

# change color range:
plotsurface(tmp, view=c('x', "y"), predictor='value', 
    main="Maunga Whau Volcano", zlim=c(0,200))

#' remove color and color legend:
plotsurface(tmp, view=c('x', "y"), predictor='value', 
    main="Maunga Whau Volcano", 
    color=NULL, col=1, add.color.legend=FALSE)

}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[graphics]{image}}, \code{\link[graphics]{contour}}, 
\code{\link{color_contour}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}}
}

