% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dotplot_error}
\alias{dotplot_error}
\title{Utility function}
\usage{
dotplot_error(x, se.val = NULL, labels = NULL, groups = NULL,
  gdata = NULL, cex = par("cex"), pch = 21, gpch = 21, bg = "black",
  color = par("fg"), gcolor = par("fg"), lcolor = "gray", xlim = NULL,
  main = NULL, xlab = NULL, ylab = NULL, lwd = 1, ...)
}
\arguments{
\item{x}{either a vector or matrix of numeric values (NAs are allowed). 
If x is a matrix the overall plot consists of juxtaposed dotplots for each 
row. Inputs which satisfy is.numeric(x) but not is.vector(x) || is.matrix(
x) are coerced by as.numeric, with a warning.}

\item{se.val}{a vector or matrix of numeric values representing the 
standard error or confidence bands.}

\item{labels}{a vector of labels for each point. For vectors the default is 
to use names(x) and for matrices the row labels dimnames(x)[[1]].}

\item{groups}{an optional factor indicating how the elements of x are 
grouped. If x is a matrix, groups will default to the columns of x.}

\item{gdata}{data values for the groups. This is typically a summary such 
as the median or mean of each group.}

\item{cex}{the character size to be used. Setting cex to a value smaller
than one can be a useful way of avoiding label overlap. Unlike many other 
graphics functions, this sets the actual size, not a multiple of par("cex").}

\item{pch}{the plotting character or symbol to be used.}

\item{gpch}{the plotting character or symbol to be used for group values.}

\item{bg}{the background color of plotting characters or symbols to be 
used; use par(bg= *) to set the background color of the whole plot.}

\item{color}{the color(s) to be used for points and labels.}

\item{gcolor}{the single color to be used for group labels and values.}

\item{lcolor}{the color(s) to be used for the horizontal lines.}

\item{xlim}{horizontal range for the plot, see plot.window, e.g.}

\item{main}{overall title for the plot, see title.}

\item{xlab}{x-axis annotation as in title.}

\item{ylab}{y-axis annotation as in title.}

\item{lwd}{with of error bars.}

\item{...}{graphical parameters can also be specified as arguments
see \code{\link[graphics]{par}}}
}
\description{
Adjusted version of the a Cleveland dot plot implemented in 
\code{\link[graphics]{dotchart}} with the option to add confidence 
intervals.
}
\examples{

# example InsectSprays from R datasets
avg <- aggregate(count ~ spray, data=InsectSprays, mean)
avg <- merge(avg, 
    aggregate(count ~ spray, data=InsectSprays, sd),
    by="spray", all=TRUE)

dotplot_error(avg$count.x, se.val=avg$count.y, labels=avg$spray)

# we could add the type of spray to the averages:
avg$type <- c(1,1,2,2,2,1)
dotplot_error(avg$count.x, se.val=avg$count.y, groups=avg$type, labels=avg$spray) 

}
\author{
This function is a slightly adjusted version of the function 
\code{\link[graphics]{dotchart}} of the package \code{\link{graphics}} 
version 3.1.1
}
\seealso{
\code{\link[graphics]{dotchart}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{drawArrows}},
  \code{\link{emptyPlot}}, \code{\link{errorBars}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

