% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_project}
\alias{mosaic_project}
\title{Project a Mosaic to a New Coordinate Reference System (CRS)}
\usage{
mosaic_project(mosaic, y, ...)
}
\arguments{
\item{mosaic}{A raster object representing the mosaic to be projected.}

\item{y}{The target CRS to which the mosaic should be projected. This can be
specified in various formats accepted by the \code{\link[terra:project]{terra::project()}} function.}

\item{...}{Additional arguments passed to the \code{\link[terra:project]{terra::project()}} function.}
}
\value{
A raster object representing the projected mosaic.
}
\description{
This function projects a given mosaic to a specified CRS.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(terra)
library(pliman)

# Create a sample mosaic
mosaic <- rast(nrow=10, ncol=10, xmin=-120, xmax=-60, ymin=30, ymax=60)
mosaic
# Define target CRS (EPSG code for WGS 84 / UTM zone 33N)
target_crs <- "EPSG:32633"

# Project the mosaic
projected_mosaic <- mosaic_project(mosaic, "EPSG:32633")
projected_mosaic
}

}
