% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_polygon.R
\name{pixel_index}
\alias{pixel_index}
\title{Get the pixel indices for a given row of a binary image}
\usage{
pixel_index(bin, row = NULL, direction = "updown")
}
\arguments{
\item{bin}{A logical matrix representing a binary image}

\item{row}{An optional row index. If not provided, the function selects the
first non-zero row.}

\item{direction}{The direction for row selection when row is not provided.
If set to \code{"updown"}, the function starts scanning from the top of the image
towards the bottom. If set to \code{"downup"}, the function starts scanning from
the bottom towards the top.}
}
\value{
A numeric vector containing the row index, the minimum pixel index,
the median pixel index, and the maximum pixel index.
}
\description{
This function finds the first row in the bin matrix that has a value greater
than 0 (TRUE). It then calculates the minimum, median, and maximum values for
the pixels in that row and creates an array containing the row index, the
minimum pixel index, the median pixel index, and the maximum pixel index.
}
\examples{
library(pliman)
leaf <- image_pliman("sev_leaf.jpg")
bin <- image_binary(leaf, "NB")[[1]]

# first row with leaf (17)
pixel_index(bin)

# index at the row 100
pixel_index(bin, row = 100)

plot(leaf)
points(x = 248, y = 17, pch = 16, col = "red", cex = 2)
points(x = 163, y = 100, pch = 16, col = "red", cex = 2)
points(x = 333, y = 100, pch = 16, col = "red", cex = 2)


}
