% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier}
\alias{efourier}
\title{Elliptical Fourier Analysis}
\usage{
efourier(x, nharm = 10, align = FALSE, center = FALSE, smooth_iter = 0)
}
\arguments{
\item{x}{A \code{matrix}, a \code{data.frame} a \code{list} of perimeter coordinates, often
produced with \code{\link[=object_contour]{object_contour()}} or a vector of landmarks produced with
\code{\link[=landmarks]{landmarks()}} or \code{\link[=landmarks_regradi]{landmarks_regradi()}}.}

\item{nharm}{An integer indicating the number of harmonics to use. Defaults
to 10.}

\item{align}{Align the objects before computing Fourier analysis? Defaults to
\code{FALSE}. If \code{TRUE}, the object is first aligned along the major caliper
with \code{\link[=poly_align]{poly_align()}}.}

\item{center}{Center the objects on the origin before computing Fourier
analysis? Defaults to \code{FALSE}. If \code{TRUE}, the object is first centered on
the origin with \code{\link[=poly_center]{poly_center()}}.}

\item{smooth_iter}{The number of smoothing iterations to perform. This will
smooth the perimeter of the objects using \code{\link[=poly_smooth]{poly_smooth()}}.}
}
\value{
A list of class \code{efourier} with:
\itemize{
\item the harmonic coefficients (\code{an}, \code{bn}, \code{cn} and \code{dn})
\item the estimates of the coordinates of the centroid of the configuration
(\code{a0} and \code{c0}).
\item The number of rows (points) of the perimeter outline (\code{nr}).
\item The number of harmonics used (\code{nharm}).
\item The original coordinates (\code{coords}).
}

If \code{x} is a list of perimeter coordinates, a list of \code{efourier} objects will
be returned as an object of class \code{iefourier_lst}.
}
\description{
Computes Elliptical Fourier Analysis of closed outlines based on \code{x} and
\code{y}-coordinates coordinates.
}
\details{
Adapted from Claude (2008). pp. 222-223.
}
\examples{
library(pliman)
leaf1 <- contours[[4]]
plot_polygon(leaf1)

#### default options
# 10 harmonics (default)
# without alignment

ef <- efourier(leaf1)
efourier_coefs(ef)

# object is aligned along the major caliper with `poly_align()`
# object is centered on the origin with `poly_center()`
# using a list of object coordinates
ef2 <- efourier(contours, align = TRUE, center = TRUE)
efourier_coefs(ef2)

# reconstruct the perimeter of the object
# Use only the first one for simplicity
plot_polygon(contours[[1]] |> poly_align() |> poly_center())
efourier_inv(ef2[[1]]) |> plot_contour(col = "red", lwd = 4)
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.

Kuhl, F. P., and Giardina, C. R. (1982). Elliptic Fourier features of a
closed contour. Computer Graphics and Image Processing 18, 236–258. doi:
\doi{10.1016/0146-664X(82)90034-X}
}
