% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier_inv}
\alias{efourier_inv}
\title{Inverse Elliptical Fourier Analysis}
\usage{
efourier_inv(x, nharm = NULL, a0 = NULL, c0 = NULL, npoints = 500)
}
\arguments{
\item{x}{An object of class \code{efourier} or \code{efourier_lst} computed with
\code{\link[=efourier]{efourier()}}.}

\item{nharm}{An integer indicating the number of harmonics to use. If not
specified the number of harmonics used in \code{x} is used.}

\item{a0, c0}{the estimates of the coordinates of the centroid of the
configuration. If \code{NULL} (default), the generated coordinates will be
centered on the position of the original shape given by \code{\link[=efourier]{efourier()}}.}

\item{npoints}{The number of interpolated points on the constructed outline.
Defaults to 500.}
}
\description{
Performs an inverse elliptical Fourier transformation to construct a shape,
given a list with Fourier coefficients computed with \code{\link[=efourier]{efourier()}}.
}
\details{
Adapted from Claude (2008). pp. 223.
}
\examples{
library(pliman)
plot_polygon(contours, aspect_ratio = 1)
# without alignment
ef <- efourier(contours, nharm = 10, align = FALSE)
ief <- efourier_inv(ef)
plot_contour(ief, col = "red", lwd = 2)
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
