% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects_rgb.R
\name{objects_rgb}
\alias{objects_rgb}
\alias{plot.objects_rgb}
\title{Get Red Green and Blue for image objects}
\usage{
objects_rgb(
  img,
  foreground = NULL,
  background = NULL,
  img_pattern = NULL,
  parallel = FALSE,
  workers = NULL,
  resize = FALSE,
  fill_hull = FALSE,
  invert = FALSE,
  index = "NB",
  my_index = NULL,
  object_index = "B",
  object_size = "large",
  tolerance = NULL,
  extension = NULL,
  lower_size = NULL,
  upper_size = NULL,
  topn_lower = NULL,
  topn_upper = NULL,
  nrows = 10000,
  show_image = TRUE,
  save_image = FALSE,
  prefix = "proc_",
  marker = NULL,
  marker_col = NULL,
  marker_size = NULL,
  marker_digits = NULL,
  dir_original = NULL,
  dir_processed = NULL,
  verbose = TRUE
)

\method{plot}{objects_rgb}(x, ...)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{foreground}{A color palette of the foreground (optional).}

\item{background}{A color palette of the background (optional).}

\item{img_pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{img_pattern = "im"} all images that the name
matches the pattern (e.g., img1.-, image1.-, im2.-) will be analyzed.
Providing any number as pattern (e.g., \code{img_pattern = "1"}) will select
images that are named as 1.-, 2.-, and so on.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time, especially when \code{img_pattern} is used is informed. The
number of sections is set up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{resize}{Resize the image before processing? Defaults to \code{FALSE}. Use a
numeric value of range 0-100 (proportion of the size of the original
image).}

\item{fill_hull}{Fill holes in the binary image? Defaults to \code{FALSE}. This is
useful to fill holes in objects that have portions with a color similar to
the background. IMPORTANT: Objects touching each other can be combined into
one single object, which may underestimate the number of objects in an
image.}

\item{invert}{Inverts the binary image, if desired. This is useful to process
images with black background. Defaults to \code{FALSE}.}

\item{index, my_index}{A character value specifying the target mode for
conversion to binary image when \code{foreground} and \code{background} are not
declared. Defaults to \code{"NB"} (normalized blue). See \code{\link[=image_index]{image_index()}} for
more details.}

\item{object_index}{The same as \code{index}, used to compute the index for each
object in the image.}

\item{object_size}{The size of the object. Used to automatically set up
\code{tolerance} and \code{extension} parameters. One of the following. \code{"small"}
(e.g, wheat grains), \code{"medium"} (e.g, soybean grains), \code{"large"}(e.g,
peanut grains), and \code{"elarge"} (e.g, soybean pods)`.}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest.}

\item{extension}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Defaults to 20. Higher value smooths out small
objects.}

\item{lower_size, upper_size}{Lower and upper limits for size for the image
analysis. Plant images often contain dirt and dust. To prevent dust from
affecting the image analysis, objects with lesser than 10\% of the mean of
all objects are removed. Upper limit is set to \code{NULL}, i.e., no upper
limit used. One can set a known area or use \code{lower_limit = 0} to select all
objects (not advised). Objects that matches the size of a given range of
sizes can be selected by setting up the two arguments. For example, if
\code{lower_size = 120} and \code{upper_size = 140}, objects with size greater than
or equal 120 and less than or equal 140 will be considered.}

\item{topn_lower, topn_upper}{Select the top \code{n} objects based on its area.
\code{topn_lower} selects the \code{n} elements with the smallest area whereas
\code{topn_upper} selects the \code{n} objects with the largest area.}

\item{nrows}{The number of lines to be used in training step.}

\item{show_image}{Show image after processing? Defaults to \code{TRUE}.}

\item{save_image}{Save the image after processing? The image is saved in the
current working directory named as \verb{proc_*} where \code{*} is the image name
given in \code{img}.}

\item{prefix}{The prefix to be included in the processed images. Defaults to
\code{"proc_"}.}

\item{marker, marker_col, marker_size, marker_digits}{The marker, color, size
and significant digits of the object marker. Defaults to \code{marker = "index"}, which shows the object index. Set to \code{marker = "id"} to show the
object id.}

\item{dir_original, dir_processed}{The directory containing the original and
processed images. Defaults to \code{NULL}. In this case, the function will
search for the image \code{img} in the current working directory. After
processing, when \code{save_image = TRUE}, the processed image will be also
saved in such a directory.}

\item{verbose}{If \code{FALSE}, runs the code silently.}

\item{x}{An object of class \code{objects_rgb}.}

\item{...}{Currently not used}
}
\value{
A list with the following objects.
\itemize{
\item \code{objects} A data frame with the measures for each object.
\item \code{rgb} A data frame with the Red, Green and Blue values for each object
\item \code{indexes} A data frame with the index computed according to the argument
\code{object_index}.
}

A \code{ggplot} object containing the distribution of the pixels for each
index.
}
\description{
Get the Red Green and Blue (RGB) for objects in an image.

Produces an histogram of an \code{objects_rgb} object
}
\details{
A binary image is first generated to segment the foreground and background.
The argument index is useful to choose a proper index to segment the image
(see \code{\link[=image_binary]{image_binary()}} for more details). Then, the number of objects in the
foreground is counted. Change \code{tolerance} and \code{extension} values to better set
up watershed-based object detection. If color palettes samples are provided, a
general linear model (binomial family) fitted to the RGB values is used to
segment fore- and background. For each segmented object, the RGB values are
obtained with. Users can also compute an index for each object using the
argument \code{object_index}, useful to classify objects based on its RGB values.

By using \code{img_pattern} it is possible to process several images with common
pattern names that are stored in the current working directory or in the
subdirectory informed in \code{dir_original}'. To speed up the computation time,
one can set \code{parallel = TRUE}.
}
\examples{
\donttest{
library(pliman)
img <- image_import(image_pliman("soy_green.jpg"))
# Segment the foreground (grains) using the normalized blue index
# Shows the average value of the blue index in each object
rgb <- objects_rgb(img)
plot(rgb)
}
\donttest{
library(pliman)

img <- image_import(image_pliman("soy_green.jpg"))
# Segment the foreground (grains) using the normalized blue index
# Shows the average value of the blue index in each object
rgb <- objects_rgb(img)
plot(rgb)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}

Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
