% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVIVEScaling.R
\name{scale_cellular_enzymatic}
\alias{scale_cellular_enzymatic}
\title{Scale clearance by age when both cellular and enzymatic clearance are known at referance age.}
\usage{
scale_cellular_enzymatic(out_ages, tot_scaled_hepcl, tot_scaled_recomcl,
  cypDb, cypCl, gender)
}
\arguments{
\item{out_ages}{Ages for which the clearance needs to be calculated including reference age}

\item{tot_scaled_hepcl}{Total cellular clearance at reference age in L/h/kg Liver}

\item{tot_scaled_recomcl}{Total Recombinant enzyme clearance at reference age in L/h/kg Liver}

\item{cypDb}{Dataframe containing cyp datasets to scale measured clearance values from in-vitro to in-vivo}

\item{cypCl}{Datafarame containing measured invitro enzymatic clearance.}

\item{gender}{Gender either "M" for male or "F" for female}
}
\value{
List with individual enzyme and total clearance at all ages.
}
\description{
This function is used internally to calculate age specific metabolism using the IVIVE gadget.
It needs both cellular and enzymatic clearance at atleast one age, the reference age, to extrapolate to values at other ages.
}
