% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{are_files_available}
\alias{are_files_available}
\title{Check whether the given files exist in the package cache.}
\usage{
are_files_available(pkg_info, relative_filenames, md5sums = NULL)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_filenames, }{vector of strings. A vector of filenames, relative to the package cache.}

\item{md5sums, }{vector of strings or NULL. A list of MD5 checksums, one for each file in param 'relative_filenames', if not NULL. If given, the files will only be reported as existing if the MD5 sums match.}
}
\value{
logical vector. For each file, whether it passed the check.
}
\description{
Check whether the given files exist in the package cache. You can pass MD5 sums, which will be verified and only files with correct MD5 hash will count as existing.
}
\examples{
    pkg_info = get_pkg_info("mypackage")
    is_available = are_files_available(pkg_info, c("file1.txt", "file2.txt"))

}
