% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-plan.R
\name{pkg_config}
\alias{pkg_config}
\title{Configuration}
\description{
Configuration options for several pkgdepends classes. Not all classes
use all of these options. E.g. a \code{\link{pkg_download_proposal}} is not concerned
about package libraries, so it'll ignore the \code{library} option.
}
\details{
Options:
\itemize{
\item \code{library}: package library to use for checking already installed
packages when considering dependencies in \link[=pkg_deps]{dependency lookup}
or \link[=pkg_installation_proposal]{package installation}. Defaults to the
first path in \code{\link[=.libPaths]{.libPaths()}}.
\item \code{cache_dir}: directory to download the packages to. Defaults to a
temporary directory within the R session temporary directory, see
\code{\link[base:tempfile]{base::tempdir()}}.
\item \code{package_cache_dir}: package cache location of
\code{\link[pkgcache:package_cache]{pkgcache::package_cache}}. The default is the pkgcache default.
\item \code{metadata_cache_dir}: location of metadata replica of
\code{\link[pkgcache:cranlike_metadata_cache]{pkgcache::cranlike_metadata_cache}}. Defaults to a temporary
directory within the R session temporary directory, see
\code{\link[base:tempfile]{base::tempdir()}}.
\item \code{platforms}: Character vector of platforms to \emph{download} or \emph{install}
for. Possible platforms are \code{windows}, \code{macos} and \code{source}. Defaults
to the current platform, \emph{and} \code{source}.
\item \code{cran-mirror}: CRAN mirror to use. Defaults to the \code{repos} option
(see \code{\link[base:options]{base::options()}}), if that's not set then
\verb{https://cran.rstudio.com}.
\item \code{dependencies}: Dependencies to consider or download or install.
Defaults to the hard dependencies, see \code{\link[=pkg_dep_types_hard]{pkg_dep_types_hard()}}.
\item \code{r-versions}: Character vector, R versions to download or install
packages for. It defaults to the current R version.
\item \code{build-vignettes}: Whether to build vignettes for package trees.
This is only used if the package is obtained from a package tree,
and not from a source (or binary) package archive. By default vignettes
are not built in this case. If you set this to \code{TRUE}, then you need
to make sure that the vignette builder packages are available, as
these are not installed by default currently.
\item \code{metadata-update-after}: A time interval as a \link{difftime} object.
pkgdepends will update the metadata cache if it is older than this.
The default is one day.
}
}
