% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{pkgcache-package}
\alias{pkgcache}
\alias{pkgcache-package}
\title{Cache for package data and metadata}
\description{
Metadata and package cache for CRAN-like repositories.
     This is a utility package to be used by package management tools
     that want to take advantage of caching.
}
\details{
Metadata and package cache for CRAN-like repositories. This is a utility
package to be used by package management tools that want to take
advantage of caching.
\subsection{Installation}{

You can install the released version of pkgcache from
\href{https://CRAN.R-project.org}{CRAN} with:\if{html}{\out{<div class="r">}}\preformatted{install.packages("pkgcache")
}\if{html}{\out{</div>}}
}

\subsection{Metadata cache}{

\code{meta_cache_list()} lists all packages in the metadata cache. It
includes Bioconductor package, and all versions (i.e. both binary and
source) of the packages for the current platform and R version.\if{html}{\out{<div class="r">}}\preformatted{library(pkgcache)
meta_cache_list()
#> # A tibble: 36,184 x 33
#>    package title version depends suggests built imports archs repodir platform
#>    <chr>   <chr> <chr>   <chr>   <chr>    <chr> <chr>   <chr> <chr>   <chr>   
#>  1 A3      "Acc~ 1.0.0   R (>= ~ randomF~ R 3.~  <NA>   <NA>  bin/ma~ macos   
#>  2 aaSEA   "Ami~ 1.1.0   R(>= 3~ knitr, ~ R 3.~ "DT(>=~ <NA>  bin/ma~ macos   
#>  3 ABACUS  "App~ 1.0.0   R (>= ~ rmarkdo~ R 3.~ "ggplo~ <NA>  bin/ma~ macos   
#>  4 abbyyR  "Acc~ 0.5.5   R (>= ~ testtha~ R 3.~ "httr,~ <NA>  bin/ma~ macos   
#>  5 abc.da~ "Dat~ 1.0     R (>= ~ <NA>     R 3.~  <NA>   <NA>  bin/ma~ macos   
#>  6 ABC.RAP "Arr~ 0.9.0   R (>= ~ knitr, ~ R 3.~ "graph~ <NA>  bin/ma~ macos   
#>  7 abc     "Too~ 2.1     R (>= ~ <NA>     R 3.~  <NA>   <NA>  bin/ma~ macos   
#>  8 abcADM  "Fit~ 1.0     <NA>    <NA>     R 3.~ "Rcpp ~ abcA~ bin/ma~ macos   
#>  9 ABCana~ "Com~ 1.2.1   R (>= ~ <NA>     R 3.~ "plotr~ <NA>  bin/ma~ macos   
#> 10 abcdeF~ "ABC~ 0.4     Rglpk,~ LIM,syb~ R 3.~  <NA>   <NA>  bin/ma~ macos   
#> # ... with 36,174 more rows, and 23 more variables: rversion <chr>,
#> #   needscompilation <chr>, priority <chr>, ref <chr>, type <chr>,
#> #   direct <lgl>, status <chr>, target <chr>, mirror <chr>, sources <list>,
#> #   filesize <int>, sha256 <chr>, sysreqs <chr>, published <dttm>, deps <list>,
#> #   license <chr>, md5sum <chr>, linkingto <chr>, enhances <chr>,
#> #   license_restricts_use <chr>, os_type <chr>, license_is_foss <chr>,
#> #   path <chr>
}\if{html}{\out{</div>}}

\code{meta_cache_deps()} and \code{meta_cache_revdeps()} can be used to look up
dependencies and reverse dependencies.

The metadata is updated automatically if it is older than seven days,
and it can also be updated manually with \code{meta_cache_update()}.

See the \code{cranlike_metadata_cache} R6 class for a lower level API, and
more control.
}

\subsection{Package cache}{

Package management tools may use the \verb{pkg_cache_*} functions and in
particular the \code{package_cache} class, to make use of local caching of
package files.

The \verb{pkg_cache_*} API is high level, and uses a user level cache:\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_summary()
#> $cachepath
#> [1] "/Users/gaborcsardi/Library/Caches/R-pkg/pkg"
#> 
#> $files
#> [1] 45
#> 
#> $size
#> [1] 62270503
}\if{html}{\out{</div>}}\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_list()
#> # A tibble: 45 x 9
#>    fullpath     path      package url      etag  sha256   version platform built
#>    <chr>        <chr>     <chr>   <chr>    <chr> <chr>    <chr>   <chr>    <int>
#>  1 /Users/gabo~ src/cont~ usethis <NA>      <NA> 1eb8efc~ <NA>    <NA>         0
#>  2 /Users/gabo~ src/cont~ testth~ <NA>      <NA> b7e0682~ <NA>    <NA>         0
#>  3 /Users/gabo~ src/cont~ waldo   <NA>      <NA> 8a33455~ <NA>    <NA>         0
#>  4 /Users/gabo~ src/cont~ testth~ <NA>      <NA> 95f987c~ <NA>    <NA>         0
#>  5 /Users/gabo~ src/cont~ testth~ <NA>      <NA> 7c068df~ <NA>    <NA>         0
#>  6 /Users/gabo~ bin/maco~ polycl~ https:/~ "\"7~ f396afd~ 1.10-0  macos       NA
#>  7 /Users/gabo~ bin/maco~ vpc     https:/~ "\"d~ ab43b8f~ 1.1.0   macos       NA
#>  8 /Users/gabo~ bin/maco~ tweenr  https:/~ "\"f~ dc551dd~ 1.0.1   macos       NA
#>  9 /Users/gabo~ bin/maco~ farver  https:/~ "\"1~ c8b5d2f~ 2.0.3   macos       NA
#> 10 /Users/gabo~ bin/maco~ ggforce https:/~ "\"4~ d635860~ 0.3.1   macos       NA
#> # ... with 35 more rows
}\if{html}{\out{</div>}}\if{html}{\out{<div class="r">}}\preformatted{pkg_cache_find(package = "dplyr")
#> # A tibble: 0 x 9
#> # ... with 9 variables: fullpath <chr>, path <chr>, package <chr>, url <chr>,
#> #   etag <chr>, sha256 <chr>, version <chr>, platform <chr>, built <int>
}\if{html}{\out{</div>}}

\code{pkg_cache_add_file()} can be used to add a file,
\code{pkg_cache_delete_files()} to remove files, \code{pkg_cache_get_files()} to
copy files out of the cache.

The \code{package_cache} class provides a finer API.
}

\subsection{Bioconductor support}{

Both the metadata cache and the package cache support Bioconductor by
default, automatically. See the \code{BioC_mirror} option and the
\code{R_BIOC_MIRROR} and \code{R_BIOC_VERSION} environment variables below to
configure pkgcache’s Bioconductor support.
}

\subsection{Package Options}{
\itemize{
\item The \code{BioC_mirror} option can be used to select a Bioconductor
mirror. This takes priority over the \code{R_BIOC_MIRROR} environment
variable.
\item \code{pkgcache_timeout} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}.
\item \code{pkgcache_connecttimeout} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds
to the \href{https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}.
\item \code{pkgcache_low_speed_limit} and \code{pkgcache_low_speed_time} are used
for a more sensible HTTP timeout. If the download speed is less than
\code{pkgcache_low_speed_limit} bytes per second for at least
\code{pkgcache_low_speed_time} seconds, the download errors. They
correspond to the
\href{https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options.
}
}

\subsection{Package environment variables}{
\itemize{
\item The \code{R_BIOC_VERSION} environment variable can be used to override
the default Bioconductor version detection and force a given
version. E.g. this can be used to force the development version of
Bioconductor.
\item The \code{R_BIOC_MIRROR} environment variable can be used to select a
Bioconductor mirror. The \code{BioC_mirror} option takes priority over
this, if set.
\item \code{PKGCACHE_TIMEOUT} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}. The
\code{pkgcache_timeout} option has priority over this, if set.
\item \code{PKGCACHE_CONNECTTIMEOUT} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds
to the \href{https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}.
The \code{pkgcache_connecttimeout} option takes precedence over this, if
set.
\item \code{PKGCACHE_LOW_SPEED_LIMIT} and \code{PKGCACHE_LOW_SPEED_TIME} are used
for a more sensible HTTP timeout. If the download speed is less than
\code{PKGCACHE_LOW_SPEED_LIMIT} bytes per second for at least
\code{PKGCACHE_LOW_SPEED_TIME} seconds, the download errors. They
correspond to the
\href{https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options. The \code{pkgcache_low_speed_time} and
\code{pkgcache_low_speed_limit} options have priority over these
environment variables, if they are set.
\item \code{R_PKG_CACHE_DIR} is used for the cache directory, if set.
(Otherwise \code{rappdirs::user_cache_dir()} is used, see also
\code{meta_cache_summary()} and \code{pkg_cache_summary()}).
}
}

\subsection{Code of Conduct}{

Please note that the ‘pkgcache’ project is released with a \href{https://github.com/r-lib/pkgcache/blob/master/.github/CODE_OF_CONDUCT.md}{Contributor Code of Conduct}.
By contributing to this project, you agree to abide by its terms.
}

\subsection{License}{

MIT © \href{https://rstudio.com}{RStudio Inc}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgcache#readme}
  \item Report bugs at \url{https://github.com/r-lib/pkgcache/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

}
