% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivot_query}
\alias{pivot_query}
\title{Create a pivot query representation}
\usage{
pivot_query(from, key, value, levels, select = ident(), order_by = NULL,
  fill = NULL)
}
\arguments{
\item{from}{the from clause}

\item{key}{Variable columns originate from}

\item{value}{The expression to evaluate to create the values}

\item{levels}{the levels of key to turn into columns.}

\item{select}{variables to select in addition to levels.}

\item{order_by}{optional order by clause}

\item{fill}{optional value to fill in structural missing values.
It is the responsibility of the user to ensure type
compatibility.}
}
\description{
Create a pivot table
}
\examples{
library(dplyr)
library(dbplyr)
con <- simulate_mssql()

query <- pivot_query( ident('##iris'), key = ident('Species')
                    , levels = ident(c('setosa', 'virginica', 'versicolor'))
                    , value  = rlang::quo(mean(Petal.Length, na.rm=TRUE))
                    )
sql_render(query, con=con)
}
