% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm_inch.R
\name{mm_inch}
\alias{mm_inch}
\title{Inches to mm}
\usage{
mm_inch(x)
}
\arguments{
\item{x}{length measured in \emph{inches}, [\emph{inch}].
Type: \code{\link{assert_double}}.}
}
\value{
length in \emph{millimeters}, [\emph{mm}].
 Type: \code{\link{assert_double}}.
}
\description{
Convert length measured in \href{https://en.wikipedia.org/wiki/Inch}{inches}
 to \href{https://en.wikipedia.org/wiki/Millimetre}{millimeters} (mm)
}
\examples{
 mm_inch(c(0.03937008, 1))
 # [1]  1.0 25.4  # [mm]

}
\seealso{
\code{\link{inch_mm}} for converting \emph{mm} to \emph{inches}

Other utils: 
\code{\link{inch_mm}()},
\code{\link{kgf_mpa}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{utils}
