% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b31gdep.R
\name{b31gdep}
\alias{b31gdep}
\title{ASME B31G. Design pressure of pipe}
\usage{
b31gdep(d, wth, smys, def)
}
\arguments{
\item{d}{nominal outside diameter of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{wth}{nominal wall thickness of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{smys}{specified minimum yield of stress (\emph{SMYS}) as a
characteristics of steel strength, [\emph{PSI}]. Type: \code{\link{assert_double}}.}

\item{def}{appropriate (combined) design factor from
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31.4.2002.pdf}{ASME B31.4},
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31.8.2003.pdf}{ASME B31.8},
or \href{https://www.asme.org/codes-standards/find-codes-standards/b31-11-slurry-transportation-piping-systems}{ASME B31.11}, [].
Type: \code{\link{assert_double}}.}
}
\value{
Design pressure of the pipe, [\emph{PSI}]. Type: \code{\link{assert_double}}.
}
\description{
Calculate the design pressure that according to
 \href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31g.1991.pdf}{ASME B31G-1991}
 is the conditioned construction characteristic that should not in no way
 exceeded.
}
\examples{
 b31gdep(30, .438, 52e3, .72)
 # [1] 1093.748  # [PSI]

}
\references{
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31g.1991.pdf}{ASME B31G-1991}.
 Manual for determining the remaining strength of corroded pipelines. A
 supplement to \emph{ASTME B31} code for pressure piping.
}
\seealso{
Other ASME B31G functions: 
\code{\link{b31crvl}()},
\code{\link{b31gacd}()},
\code{\link{b31gacl}()},
\code{\link{b31gafr}()},
\code{\link{b31gmodpf}()},
\code{\link{b31gops}()},
\code{\link{b31gpf}()},
\code{\link{b31gsap}()}
}
\concept{ASME B31G functions}
