% Generated by roxygen2 (4.0.1): do not edit by hand
\name{free-piping}
\alias{\%:>\%}
\alias{free-piping}
\title{Pipe an object forward as \code{.} to an expression}
\usage{
. \%:>\% expr
}
\arguments{
\item{.}{The object to be piped as represented by \code{.}}

\item{expr}{The expression to evaluate with the piped object referred to as \code{.}}
}
\description{
The operator \code{\%:>\%} evaluates the expression on the right-hand side
with the left-hand side object referred to as \code{.}.
}
\examples{
\dontrun{
rnorm(100) \%:>\% plot(.)

rnorm(100) \%:>\% plot(.,col="red")

rnorm(1000) \%:>\% sample(.,size=length(.)*0.1,replace=FALSE)

rnorm(1000) \%:>\%
  sample(.,length(.)*0.1,FALSE) \%>>\%
  plot(.,main=sprintf("length: \%d",length(.)))
}
}

