% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dns.R
\name{nsl}
\alias{nsl}
\title{DNS query}
\usage{
nsl(domain, server = NULL, type = 1L, class = 1L)
}
\arguments{
\item{domain}{Domain to query.}

\item{server}{Custom name server IP address, to use. Note that this
must be an IP address currently. E.g. 8.8.8.8 is Google's DNS server.}

\item{type}{Record type to query, an integer scalar. 1L is an A record,
28L is an AAAA record, etc. See e.g.
https://en.wikipedia.org/wiki/List_of_DNS_record_types for the record
types.}

\item{class}{Query class. This is usually 1L, i.e. "Internet". See e.g.
https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-2
for all DNS classes.}
}
\value{
A list of two entries currently, additional entries might be
added later:
\itemize{
\item \code{answer}: a data frame of DNS records, with columns:
\code{name}, \code{class}, \code{type}, \code{ttl}, \code{data}. \code{data} is a list column and
contains the IP(6) address for A and AAAA records, but it contains
other data, e.g. host name for CNAME, for other records. If pingr
could not parse a record (it only parses the most common records
types: A, AAAA, NA, PTR, CNAME, TXT, MX, SOA), then the data of
the record is included as a raw vector.
\item \code{flags}: a named logical vector of flags \code{aa}, \code{tc}, \code{rd}, \code{ra},
\code{ad}, \code{cd}. See the RFC (https://www.ietf.org/rfc/rfc1035.txt) for
these. On Windows they are all set to NA currently.
}
}
\description{
Perform a DNS query for a domain. It supports custom name servers,
and querying DNS records of certain class and type.
}
\examples{
nsl("r-project.org")
nsl("google.com", type = 28L)
}
