% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.matrix.pim.R
\docType{methods}
\name{model.matrix.pim}
\alias{model.matrix}
\alias{model.matrix,pim-method}
\alias{model.matrix,pim.formula-method}
\alias{model.matrix.pim}
\alias{model.matrix.pim.formula}
\title{Create a model matrix for a probabilistic index model}
\usage{
model.matrix(object, ...)

\S4method{model.matrix}{pim}(object, data, ...)

\S4method{model.matrix}{pim.formula}(object, data, model = c("difference",
  "marginal", "regular", "customized"), ...)
}
\arguments{
\item{object}{a \code{\link{pim.formula}} object that contains
the formula necessary for constructing the model matrix.}

\item{...}{extra arguments passed to or from other methods.
This is currently only implemented in concordance with
the generic \code{\link[stats]{model.matrix}} function.}

\item{data}{an optional argument specifying the data frame for which
the model matrix should be constructed. See also 
\code{\link[stats]{model.matrix})} in the \code{stats} package.}

\item{model}{a single character value with possible values "difference" 
(the default), "marginal", "regular" or "customized". See also
\code{\link{pim}}.}
}
\value{
a design matrix for a pim model
}
\description{
This function creates a model matrix for use in a probabilistic
index model. This model matrix can be passed to \code{\link{pim.fit}}.
}
\examples{
data("FEVData")
# Create the "model frame"
FEVenv <- new.pim.env(FEVData, compare="unique")
# This includes the poset
pos <- poset(FEVenv, as.list=TRUE)

# create the formula and bind it to the pim.environment.
FEVform <- new.pim.formula(
  Age ~ I(L(Height) - R(Height))  ,
  FEVenv
)

# Use this formula object to construct the model matrix
# use the default model ( difference )
MM <- model.matrix(FEVform)

# Use this formula object to construct the pseudo response
Y <- response(FEVform)

# Now pim.fit can do what it does
res <- pim.fit(MM,Y, estim = "estimator.glm", penv=FEVenv)

}

