% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_new_pillar.R
\name{ctl_new_pillar}
\alias{ctl_new_pillar}
\alias{ctl_new_compound_pillar}
\title{Customize your tibble subclass}
\usage{
ctl_new_pillar(controller, x, width, ..., title = NULL)

ctl_new_compound_pillar(controller, x, width, ..., title = NULL)
}
\arguments{
\item{controller}{The object of class \code{"tbl"} currently printed.}

\item{x}{A vector, can also be a data frame, array or matrix
in \code{ctl_new_compound_pillar()}}

\item{width}{The available width, can be a vector for multiple tiers}

\item{...}{These dots are for future extensions and must be empty.}

\item{title}{The title, derived from the name of the column in the data}
}
\description{
Gain full control over the appearance of the pillars of your tibble subclass
in its body.
These methods are intended for implementers of subclasses of the \code{"tbl"}
class.
Users will rarely need them.
}
\details{
\code{ctl_new_pillar()} is called to construct pillars for regular (one-dimensional)
vectors.
The default implementation returns an object constructed with \code{\link[=pillar]{pillar()}}.
Extend this method to tweak pillar components returned from the default
implementation.
Override this method to completely change the appearance of the pillars.

\code{ctl_new_compound_pillar()} is called for compound pillars: columns
that are data frames, matrices or arrays.
The default implementation returns a compound pillar with suitable formatting
for the titles and types of the sub-pillar.
Users will only rarely need to override this method if ever.

Implementations should return \code{NULL} if none of the data
fits the available width.
}
\examples{
lines <- function(char = "-") {
  stopifnot(nchar(char) == 1)
  structure(char, class = "lines")
}

format.lines <- function(x, width, ...) {
  paste(rep(x, width), collapse = "")
}

ctl_new_pillar.line_tbl <- function(controller, x, width, ..., title = NULL) {
  out <- NextMethod()
  new_pillar(list(
    title = out$title,
    type = out$type,
    lines = new_pillar_component(list(lines("=")), width = 1),
    data = out$data
  ))
}

vctrs::new_data_frame(
  list(a = 1:3, b = letters[1:3]),
  class = c("line_tbl", "tbl")
)
}
