% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cerror.R
\name{\%~~\%}
\alias{\%~~\%}
\title{Correlated error operator}
\usage{
e1 \%~~\% e2
}
\arguments{
\item{e1}{first variable involved in correlated error}

\item{e2}{second variable involved in correlated error}
}
\description{
Specifies correlated errors among predictors
}
\details{
For use in \code{psem} to identify correlated sets of variables.
}
\examples{
# Generate example data
dat <- data.frame(x1 = runif(50),
  x2 = runif(50), y1 = runif(50),
    y2 = runif(50))

# Create list of structural equations
sem <- psem(
  lm(y1 ~ x1 + x2, dat),
  lm(y2 ~ y1 + x1, dat)
)

# Look at correlated error between x1 and x2
# (exogenous)
cerror(x1 \%~~\% x2, sem, dat)

# Same as cor.test
with(dat, cor.test(x1, x2))

# Look at correlatde error between x1 and y1
# (endogenous)
cerror(y1 \%~~\% x1, sem, dat)

# Not the same as cor.test
# (accounts for influence of x1 and x2 on y1)
with(dat, cor.test(y1, x1))

# Specify in psem
sem <- update(sem, x1 \%~~\% y1)

coefs(sem)

}
\seealso{
\code{\link{cerror}}
}
\author{
Jon Lefcheck <LefcheckJ@si.edu>, Jarrett Byrnes
}
