% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-index.R
\name{as.ts.piar_index}
\alias{as.ts.piar_index}
\title{Coerce an index into a time series}
\usage{
\method{as.ts}{piar_index}(x, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{...}{Additional arguments passed to \code{\link[=ts]{ts()}}.}
}
\value{
A time series object.
}
\description{
Turn an index into a regular time series, represented as a \code{\link{ts}} object.
}
\examples{
as.ts(as_index(matrix(1:9, 3)))

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
