% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-plot.R
\name{plot_data}
\alias{plot_data}
\alias{plot_bayes.communityPGLMM}
\title{Plot the original dataset and predicted values (optional)}
\usage{
plot_data(
  x,
  sp.var = "sp",
  site.var = "site",
  show.sp.names = FALSE,
  show.site.names = FALSE,
  digits = max(3, getOption("digits") - 3),
  predicted = FALSE,
  ...
)

\method{plot_bayes}{communityPGLMM}(x, n_samp = 1000, sort = TRUE, ...)
}
\arguments{
\item{x}{A communityPGLMM object fit with \code{bayes = TRUE}.}

\item{sp.var}{The variable name of "species"; y-axis of the image.}

\item{site.var}{The variable name of "site"; x-axis of the image.}

\item{show.sp.names}{Whether to print species names as y-axis labels.}

\item{show.site.names}{Whether to print site names as x-axis labels.}

\item{digits}{Not used.}

\item{predicted}{Whether to plot predicted values side by side with observed ones.}

\item{...}{Further arguments to pass to or from other methods.}

\item{n_samp}{Number of sample from the marginal posterior to take in order to estimate the posterior density.}

\item{sort}{Whether to plot different terms in the order of their estimations. Default is 'TRUE'.}
}
\value{
A ggplot object
}
\description{
Plots a representation of the marginal posterior distribution of model parameters. Note this
function requires the packages \code{ggplot2} and \code{ggridges} to be installed.
}
\note{
The underlying plot grid object is returned but invisible. It can be saved for later uses.
}
