% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{align_comm_V}
\alias{align_comm_V}
\title{Create phylogenetic var-cov matrix based on phylogeny and community data}
\usage{
align_comm_V(comm, tree, prune.tree = FALSE, scale.vcv = TRUE)
}
\arguments{
\item{comm}{A site by species data frame, with site names as row names.}

\item{tree}{A phylogeny with "phylo" as class; or a phylogenetic var-covar matrix.}

\item{prune.tree}{Whether to prune the tree first then use vcv.phylo function. Default
is FALSE: use vcv.phylo first then subsetting the matrix.}

\item{scale.vcv}{Whether to scale vcv to a correlation matrix.}
}
\value{
A list of the community data and the phylogenetic var-cov matrix.
}
\description{
This function will remove species from community data that are not in the phylogeny.
It will also remove tips from the phylogeny that are not in the community data. And
then convert the phylogeny to a Var-cov matrix.
}
