\name{supermat}
\alias{supermat}

\title{
Build super matrix using PHYLIP files
}
\description{
This function could be used to build the super dataframe described by Kress et al.(2009). The out put dataframe could be converted to Phylip format file for phylogenetic analysis.
}
\usage{
supermat(rbcl = NULL, matk = NULL, trn = NULL)
}
\arguments{
  \item{rbcl}{
A character string indicting the name of rbcl phylip file.
}
  \item{matk}{
A character string indicting the name of matK phylip file.
}
  \item{trn}{
A vector of character strings indicting the names of trnH-psbA phylip files.
}
}

\details{
The phylip files should be first put into a directory. Users are encouraged to copy the phylip files which generated by software Clustal to a directory, and then set it as the working directory. The function will search the input phylip file names from the working directory and build the "super" dataframe. The dataframe then could be converted to phylip format by dat2phy and be written to the working directory by \code{\link{writeLines}} so that to generate a super matrix. 

}
\value{
The super data frame to be converted to supermatrix.
}
\references{
Kress W., Erickson D., Jones F., Swenson N., Perez R., Sanjur O., Bermingham E., Plant DNA barcodes and community phylogeny of a tropical forest dynamics plot in Panama. Proceedings of the National Academy of Sciences of the United States of America. 2009 18621-18626
}
\author{

Jinlong Zhang \email{jinlongzhang01@gmail.com}

}
\note{
None.
}

\seealso{
See Also \code{\link{dat2phy}}, \code{\link{writeLines}}
}
\examples{

dir <- system.file("extdata", package = "phylotools")
setwd(dir)
## Supermatrix with "rbcla","matk","trnH-psbA"
supermat1 <- supermat(rbcl = "rbcla.phy", matk = "matK.phy", 
           trn = c("trn1.phy", "trn2.phy","trn3.phy","trn4.phy"))	   
write.mat(supermat1, "result1.phy")


## Supermatrix with"matk","trnH-psbA"
supermat2 <- supermat(matk = "matK.phy", 
           trn = c("trn1.phy", "trn2.phy","trn3.phy","trn4.phy"))	      
write.mat(supermat2, "result2.phy")


## Supermatrix with "rbcla","matk"
supermat3 <- supermat(matk = "matK.phy", rbcl = "rbcla.phy")	   
write.mat(supermat3, "result3.phy")


## Supermatrix with "rbcla","trnH-psbA"
supermat4 <- supermat(rbcl = "rbcla.phy", 
           trn = c("trn1.phy", "trn2.phy","trn3.phy","trn4.phy"))	   
write.mat(supermat4, "result4.phy")

## Delete the results
unlink(c("result1.phy", "result2.phy", "result3.phy", "result4.phy"))

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ supermat }
\keyword{ print}
