\name{read.seqgen}
\alias{read.seqgen}
\title{Read seqgen's Results and Return a seq.data}
\description{
  This function can read the results generated by \code{seqgen} and
  turn into a object in \code{Class seq.data}.
}
\usage{
read.seqgen(text, byrow = TRUE, code.type = .code.type[1])
}
\arguments{
  \item{text}{a text vector generated by \code{seqgen}.}
  \item{byrow}{advanced option, default = TRUE.}
  \item{code.type}{either "NUCLEOTIDE" (default) or "SNP".}
}
\details{
  If \code{code.type} is "SNP", the A, G will be transfered to 1, and
  the C, T will be transfered to 2.

}
\value{
  Return an object in \code{Class seq.data}.
}
\references{
  Phylogenetic Clustering Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/phyclust/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com}
}
\seealso{
  \code{\link{seqgen}},
  \code{\link{gen.seq.HKY}},
  \code{\link{gen.seq.SNP}}.
}
\examples{
\dontrun{
library(phyclust, quiet = TRUE)

set.seed(123)
ret.ms <- ms(nsam = 5, nreps = 1, opts = "-T")
ret.seqgen <- seqgen(opts = "-mHKY -l40 -s0.2", newick.tree = ret.ms[3])
(ret.nucleotide <- read.seqgen(ret.seqgen))
(ret.snp <- read.seqgen(ret.seqgen, code.type = "SNP"))
}
}
\keyword{file I/O}
\keyword{Seq-Gen}
