% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photon-package.R
\docType{package}
\name{photon-package}
\alias{photon}
\alias{photon-package}
\title{photon: High-Performance Geocoding using 'photon'}
\description{
Features unstructured, structured and reverse geocoding using the 'photon' geocoding API <[https://photon.komoot.io/]https://photon.komoot.io/>. Facilitates the setup of local 'photon' instances to enable offline geocoding.
}
\section{Terms of use}{

From \url{https://photon.komoot.io} on using the public API:

\emph{"You can use the API for your project, but please be fair - extensive usage
will be throttled. We do not guarantee for the availability and usage might
be subject of change in the future."}

Note that these terms only apply to the public API
(\code{\link[=new_photon]{new_photon()}}), and not to local instances
(e.g. \code{\link[=new_photon]{new_photon(path = ".")}})! For the public
API, the package sets a default of 1 request per second (see below).
}

\section{Global options}{

A number of global options can be set that change the behavior of package
functions. These include:

\describe{
 \item{\code{photon_throttle}}{Rate limit used to throttle requests.
 By default, no throttle is set for non-komoot instances. For komoot's
 public API, this option defaults to 1 request per second. See
 \code{\link[httr2]{req_throttle}}.}
 \item{\code{photon_max_tries}}{Number of retries a failing request should
 do before ultimately aborting. Defaults to 3. See
 \code{\link[httr2]{req_retry}}.}
 \item{\code{photon_debug}}{Whether to echo the command of external
 processes and GET requests sent to photon. Defaults to \code{FALSE}.}
 \item{\code{photon_movers}}{Whether moving verbosity is allowed. If
 \code{FALSE}, disables progress bars and spinners globally. Overwritten
 by local parameters. Defaults to \code{TRUE}. This option is useful for
 non-interactive sessions like RMarkdown.}
 \item{\code{photon_setup_warn}}{Whether to convert warnings in the photon
 logs to R warnings. Many warnings in the log are somewhat useless, but
 some can be important. Defaults to \code{TRUE}.}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jslth/photon/}
  \item \url{https://jslth.github.io/photon/}
  \item Report bugs at \url{https://github.com/jslth/photon/issues}
}

}
\author{
\strong{Maintainer}: Jonas Lieth \email{jonas.lieth@gesis.org} (\href{https://orcid.org/0000-0002-3451-3176}{ORCID}) [copyright holder]

}
\keyword{internal}
