% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{soundex}
\alias{soundex}
\alias{refinedSoundex}
\title{Soundex}
\usage{
soundex(word, maxCodeLen = 4L)

refinedSoundex(word, maxCodeLen = 10L)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
soundex encoded character vector
}
\description{
The Soundex phonetic algorithms
}
\details{
The function \code{soundex} phonentically encodes the given
string using the soundex algorithm.  The function \code{refinedSoundex}
uses Apache's refined soundex algorithm.  Both implementations are loosely
based on the Apache Commons Java editons.

The variable \code{maxCodeLen} is the limit on how long the returned
soundex should be.
}
\examples{
soundex("wheel")
soundex(c("school", "benji"))

}
\references{
Charles P. Bourne and Donald F. Ford, "A study of methods for
systematically abbreviating English words and names," \emph{Journal
of the ACM}, vol. 8, no. 4 (1961), p. 538-552.

Howard B. Newcombe, James M. Kennedy, "Record linkage: making
maximum use of the discriminating power of identifying information,"
\emph{Communications of the ACM}, vol. 5, no. 11 (1962), p. 563-566.
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{cologne}}, \code{\link{lein}},
  \code{\link{metaphone}}, \code{\link{mra_encode}},
  \code{\link{nysiis}}, \code{\link{onca}},
  \code{\link{phonex}}, \code{\link{rogerroot}},
  \code{\link{statcan}}
}
