% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_eaf.R
\name{df_to_eaf}
\alias{df_to_eaf}
\title{Dataframe to .eaf}
\usage{
df_to_eaf(df, output_file, output_dir = "", ref_file = "", mime_type = "")
}
\arguments{
\item{df}{an R dataframe object that contains columns named 'tier', 'id', 'tier_name',
'content', 'time_start', 'time_end' and preferably also 'tier_type', 'stereotype',
'tier_ref', 'event_local_id', 'dependent_on' that are specific for eaf file}

\item{output_file}{the name of the result .xml file}

\item{output_dir}{the output directory for the rendered file (defalut is used if not spectified)}

\item{ref_file}{a filepath for connected media file (not obligatory)}

\item{mime_type}{a MIME type of connected media file (not obligatory)}
}
\value{
.xml file
}
\description{
Convert a dataframe to Elan file .exb
}
\examples{

df <- eaf_to_df(system.file("extdata", "test.eaf", package = "phonfieldwork"))

df_to_eaf(df = df,
          output_file = 'test.eaf',
          ref_file = 'test.wav')

# Remove file in order to pass checks

file.remove("test.eaf")

}
\author{
Sergej Kudrjashov <xenomirant@gmail.com>
}
