% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_param.R
\name{init_param}
\alias{init_param}
\title{init_param}
\usage{
init_param(y, t, w)
}
\arguments{
\item{y}{input vegetation index time-series.}

\item{t}{the corresponding doy(day of year) of y.}

\item{w}{weights}
}
\description{
Initialize parameters of double logistic function
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c(
    mn  = 0.1,
    mx  = 0.7,
    sos = 50,
    rsp = 0.1,
    eos = 250,
    rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

l_param <- init_param(y, t)
}
\keyword{internal}
