% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_optim.R
\name{I_optim}
\alias{I_optim}
\alias{I_optimx}
\title{Interface of unified optimization functions.}
\usage{
I_optim(prior, FUN, y, t, tout, method = "BFGS", ...)

I_optimx(prior, FUN, y, t, tout, method, verbose = FALSE, ...)
}
\arguments{
\item{prior}{A vector of initial values for the parameters for which optimal
values are to be found. \code{prior} is suggested giving a column name.}

\item{FUN}{Fine curve fitting function for goal function \code{\link{f_goal}}.}

\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{tout}{Corresponding doy of prediction.}

\item{method}{\code{method} can be one of \code{'BFGS','CG','Nelder-Mead',
'L-BFGS-B', 'nlm', 'nlminb', 'ucminf'}. \cr
For \code{I_optimx}, other methods are also supported,
e.g. \code{'spg','Rcgmin','Rvmmin', 'newuoa','bobyqa','nmkb','hjkb'}.}

\item{...}{other parameters passed to \code{\link{I_optim}} or \code{\link{I_optimx}}.}

\item{verbose}{If \code{TRUE}, all optimization methods in
\code{\link[optimx]{optimx}} are used, and print optimization information
of all methods.}
}
\value{
\describe{
\item{convcode}{ An integer code. 0 indicates successful convergence.
Various methods may or may not return sufficient information to allow all
the codes to be specified. An incomplete list of codes includes
\describe{
     \item{\code{1}}{indicates that the iteration limit \code{maxit}
     had been reached.}
     \item{\code{20}}{indicates that the initial set of parameters is
     inadmissible, that is, that the function cannot be computed or returns
     an infinite, NULL, or NA value.}
     \item{\code{21}}{indicates that an intermediate set of parameters is inadmissible.}
     \item{\code{10}}{indicates degeneracy of the Nelder--Mead simplex.}
     \item{\code{51}}{indicates a warning from the \code{"L-BFGS-B"}
     method; see component \code{message} for further details.}
     \item{\code{52}}{indicates an error from the \code{"L-BFGS-B"}
     method; see component \code{message} for further details.}
     \item{\code{9999}}{error}
}
}
\item{value}{ The value of fn corresponding to par }
\item{par}{ The best parameter found }
\item{nitns}{ the number of iterations }
\item{fevals}{ The number of calls to \code{objective}. }
}
}
\description{
Caution that \pkg{optimx} speed is not so satisfied. So \code{I_optim}
is present.
}
\examples{
library(ggplot2)
library(magrittr)
library(purrr)

# simulate vegetation time-series
fFUN = doubleLog.Beck
par = c(
  mn  = 0.1,
  mx  = 0.7,
  sos = 50,
  rsp = 0.1,
  eos = 250,
  rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

# initial parameter
par0 <- c(
  mn  = 0.15,
  mx  = 0.65,
  sos = 100,
  rsp = 0.12,
  eos = 200,
  rau = 0.12)

objective <- f_goal # goal function
optFUNs   <- c("opt_ucminf", "opt_nlminb", "opt_nlm", "opt_optim") \%>\% set_names(., .)
prior <- as.matrix(par0) \%>\% t() \%>\% rbind(., .)

opt1 <- I_optim(prior, fFUN, y, t, tout, c("BFGS", "ucminf", "nlm", "nlminb"))
opt2 <- I_optimx(prior, fFUN, y, t, tout, c("BFGS", "ucminf", "nlm", "nlminb"))

# microbenchmark::microbenchmark(
#     I_optim(prior, fFUN, y, t, tout, c("BFGS", "ucminf", "nlm", "nlminb")),
#     I_optimx(prior, fFUN, y, t, tout, c("BFGS", "ucminf", "nlm", "nlminb")),
#     times = 2
# )
}
\seealso{
\code{\link[stats]{optim}}, \code{\link[stats]{nlminb}},
\code{\link[stats]{nlm}}, \code{\link[optimx]{optimx}},
\code{\link[ucminf]{ucminf}}
}
