% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenoSim.R
\name{phenoSim}
\alias{phenoSim}
\title{Simulate Green-up Phenology Data}
\usage{
phenoSim(nSites = 1000, nTSet = c(3:6), p = 2, beta = NULL, sig = 0.1,
  tau = 0.01, miss = 0, plotFlag = FALSE, ymax = 1, trend = +1)
}
\arguments{
\item{nSites}{Number of sites/seasons}

\item{nTSet}{A vector of integer values. Length of each time-series will be randomly sampled from this vector.}

\item{p}{Number of predictors in the model.}

\item{beta}{Beta coefficients}

\item{sig}{Process error.}

\item{tau}{Observation error.}

\item{miss}{Fraction of missing data.}

\item{plotFlag}{logical value indicating whether to plot the resulted time-series.}

\item{ymax}{Asymptotic maximum values.}

\item{trend}{time-series expected trend as -1:decreasing, +1:increasing, 0: not constrained}
}
\description{
This function return a set of simulated data for multiple green-up phenology time-series.
}
\examples{

#Simulate Phenology Data
ssSim <- phenoSim(nSites = 2, #number of sites
                  nTSet = 30, #number of time steps
                  beta = c(1, 2), #beta coefficients
                  sig = .01, #process error
                  tau = .1, #observation error
                  plotFlag = TRUE, #whether plot the data or not
                  miss = 0.05, #fraction of missing data
                  ymax = c(6, 3) #maximum of saturation trajectory
)

}
\keyword{Data}
\keyword{Phenology}
\keyword{Simulate}
