% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_outs.R
\name{ph_anomaly}
\alias{ph_anomaly}
\title{Detect anomalies.}
\usage{
ph_anomaly(
  df,
  ids_col,
  class_col,
  method = "ae",
  scale = FALSE,
  center = NULL,
  sd = NULL,
  max_mem_size = "15g",
  port = 54321,
  train_seed = 123,
  hyper_params = list(),
  search = "random",
  tune_length = 100
)
}
\arguments{
\item{df}{A \code{data.frame} containing a column of ids, a column of classes, and an arbitrary number of predictors.}

\item{ids_col}{A \code{character} value for the name of the ids column.}

\item{class_col}{A \code{character} value for the name of the class column.}

\item{method}{A \code{character} value for the anomaly detection method: "ae" (default), "iso" (abbv. for extended isolation forest).}

\item{scale}{A \code{logical} value for whether to scale the data: FALSE (default). Recommended if \code{method = "ae"} and if user intends to train other models.}

\item{center}{Either a \code{logical} value or numeric-alike vector of length equal to the number of columns of data to scale in \code{df}, where ‘numeric-alike’ means that as.numeric(.) will be applied successfully if is.numeric(.) is not true: NULL (default). If \code{scale = TRUE}, this is set to \code{TRUE} and is used to subtract the mean.}

\item{sd}{Either a \code{logical} value or a numeric-alike vector of length equal to the number of columns of data to scale in \code{df}: NULL (default). If \code{scale = TRUE}, this is set to \code{TRUE} and is used to divide by the standard deviation.}

\item{max_mem_size}{A \code{character} value for the memory of an h2o session: "15g" (default).}

\item{port}{A \code{numeric} value for the port number of the H2O server.}

\item{train_seed}{A \code{numeric} value to set the control the randomness of creating resamples: 123 (default).}

\item{hyper_params}{A \code{list} of hyperparameters to perform a grid search.
\itemize{
\item If \code{method = "ae"}, the "default" list is: list(missing_values_handling = "Skip", activation = c("Rectifier", "Tanh"), hidden = list(5, 25, 50, 100, 250, 500, nrow(df_h2o)), input_dropout_ratio = c(0, 0.1, 0.2, 0.3), rate = c(0, 0.01, 0.005, 0.001))
\item If \code{method = "iso"}, the "default" list is: list(ntrees = c(50, 100, 150, 200), sample_size = c(64, 128, 256, 512))
}}

\item{search}{A \code{character} value for the hyperparameter search strategy: "random" (default), "grid".}

\item{tune_length}{A \code{numeric} value (integer) for either the maximum number of hyperparameter combinations ("random") or individual hyperparameter depth ("grid"): 100 (default).}
}
\value{
A list containing the following components:\tabular{ll}{
\code{df} \tab The data frame with anomalies removed. \cr
\tab \cr
\code{model} \tab The best model from the grid search used to detect anomalies. \cr
\tab \cr
\code{anom_score} \tab A data frame of predicted anomaly scores. \cr
}
}
\description{
The \code{ph_anomaly} function detects and removes anomalies with an autoencoder. Because it is general
purpose, it can be applied to a variety of data types. The parameters in this function (e.g., activation,
hidden, dropout_ratio) can be supplied as lists or vectors (see parameter details) to perform a grid search
for the optimal hyperparameter combination. The autoencoder with the lowest reconstruction error is selected as
the best model.
}
\examples{
## Import data.
data(ph_crocs)
\donttest{
## Remove anomalies with autoencoder.
rm_outs <- ph_anomaly(df = ph_crocs, ids_col = "Biosample",
                      class_col = "Species", method = "ae")
## Alternatively, remove anomalies with extended isolation forest. Notice
## that port is defined, because running H2O sessions one after another
## can return connection errors.
rm_outs <- ph_anomaly(df = ph_crocs, ids_col = "Biosample",
                      class_col = "Species", method = "iso",
                      port = 50001)
}
}
