% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Estimate operating characteristics of a randomised clinical trial design that
assumes a Bernoulli distributed primary outcome variable}
\usage{
sim(
  des = ph2rand::des_one_stage(),
  pi = des$opchar[, 1:2],
  k = 1:des$J,
  replicates = 10000,
  summary = FALSE
)
}
\arguments{
\item{des}{An object of class \code{ph2rand_des}, as returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}. Defaults to
\code{ph2rand::des_one_stage()}.}

\item{pi}{A \code{\link{numeric}} \code{\link{vector}} with two elements, or
a \code{\link{numeric}} \code{\link{matrix}} or \code{\link{data.frame}} with
two columns, giving the response rate scenarios to consider. The first
element/column should correspond to the control arm and the second
element/column to the experimental arm. Defaults to \code{des$opchar[, 1:2]}.}

\item{k}{A \code{\link{numeric}} \code{\link{vector}} indicating which stages
to consider in determining the operating characteristics. That is, it will
condition the calculations on the trial ending in the stages given in
\code{k}. Defaults to \code{1:des$J} (i.e., to all stages of the given
design).}

\item{replicates}{A \code{\link{numeric}} indicating the number of replicate
simulations to use for each value of
\ifelse{html}{\out{<b><i>&pi;</i></b>}}{\eqn{\bold{\pi}}}. Defaults to
\code{1e4}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} with additional class \code{"ph2rand_sim"},
containing each of the input parameters along with a tibble in the slot
\code{$sim}, which gives the estimated operating characteristics.
}
\description{
\code{sim} estimated the operating characteristics (via simulation) of a
design returned by \code{\link{des_one_stage}} or
\code{\link{des_two_stage}}, under given response rate scenarios (see
\code{pi}).
}
\examples{
# The default two-stage design
des <- des_two_stage()
# Its operating characteristics under the uninteresting and interesting
# scenarios
sim <- sim(des)
# The same operating characteristics, conditioning on the trial ending in
# stage 2
sim <- sim(des, k = 2)
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}}.
}
