% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multpostp.R
\name{MultPostP}
\alias{MultPostP}
\title{The posterior probability criterion function for Phase II single-arm design}
\usage{
MultPostP(x, n, a.vec, p0)
}
\arguments{
\item{x}{the value of observed data.  It can be \eqn{x_{E}=y_{ET}+y_{E T^C}} i.e. number of responses for efficacy among \eqn{n} patients treated by the experimental drug, or \eqn{x_{T}= y_{ET}+y_{E^C T}} i.e. number of responses for toxicity among \eqn{n} patients treated by the experimental drug, where \eqn{y = (y_{ET}, y_{E^C T}, y_{ET^C}, y_{E^C T^C})}, that is, among \eqn{n} patients treated by the experimental drug, \eqn{y_{ET}} of them have experienced both toxicity and efficacy, \eqn{y_{E^C T}} have experienced toxicity only, \eqn{y_{ET^C}} have experienced efficacy only, \eqn{y_{E^C T^C}} have neither experienced toxicity nor efficacy.}

\item{n}{the number of patients treated by the experimental drug at a certain stage of the trial.}

\item{a.vec}{the hyperparameter vector of the Dirichlet prior for the experimental drug.}

\item{p0}{the prespecified reseponse rate for efficacy, futility or toxicity.}
}
\value{
\item{prob}{the posterior probability: \eqn{Pr(p_E > p_0 | X=x_E)} or \eqn{Pr(p_T > p_0 | X=x_T)}}
}
\description{
Thall, Simon and Estey's criterion function for determining the trial decision boundaries for efficacy (futility) and safety (toxicity).
}
\examples{
n <- 30; x.eff <- 5; x.tox <- 8; param <- c(1,1,1,1); p0.eff <- 0.9; p0.tox <- 0.95
MultPostP(x=x.eff, n=n, a.vec=param, p0=p0.eff)
MultPostP(x=x.tox, n=n, a.vec=param, p0=p0.tox)
}
\references{
Berry, S. M., Carlin, B. P., Lee, J. J., & Muller, P. (2010).
\emph{Bayesian adaptive methods for clinical trials.}
CRC press.

Thall, Peter F., Richard M. Simon, and Elihu H. Estey. (1995).
\emph{Bayesian sequential monitoring designs for single-arm clinical trials with multiple outcomes.}
\emph{Statistics in medicine} \strong{14.4}: 357-379.

Yin, G. (2013).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

