/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.InputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

public class ASCIIHexDecode
extends InputStream {
    private InputStream in;
    private boolean closeSource;

    public ASCIIHexDecode(InputStream inputStream, PSObjectDict pSObjectDict) throws PSError {
        this.in = inputStream;
        PSObject pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSESOURCE);
        this.closeSource = pSObject != null ? pSObject.toBool() : false;
    }

    public int available() throws IOException {
        if (this.in != null) {
            int n = this.in.available();
            n = (n + 1) / 2;
            return n;
        }
        throw new IOException();
    }

    public void close() throws IOException {
        if (this.closeSource) {
            this.in.close();
        }
        this.in = null;
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n = this.readNextHexChar();
        if (n == -1) {
            return -1;
        }
        int n2 = this.readNextHexChar();
        if (n2 == -1) {
            n2 = 0;
        }
        return 16 * n + n2;
    }

    private int readNextHexChar() throws IOException {
        int n;
        do {
            if ((n = this.in.read()) >= 48 && n <= 57) {
                n -= 48;
            } else if (n >= 65 && n <= 70) {
                n -= 55;
            } else {
                if (n < 97 || n > 102) continue;
                n -= 87;
            }
            break;
        } while (n != -1);
        return n;
    }

    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        this.in.reset();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(2L * l);
    }
}

