/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.io.IOException;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorIOError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectFile;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public class Image {
    public static final PSObjectName IMAGE_TYPE = new PSObjectName("/ImageType");
    public static final PSObjectName WIDTH = new PSObjectName("/Width");
    public static final PSObjectName HEIGHT = new PSObjectName("/Height");
    public static final PSObjectName IMAGE_MATRIX = new PSObjectName("/ImageMatrix");
    public static final PSObjectName MULTIPLE_DATA_SOURCES = new PSObjectName("/MultipleDataSources");
    public static final PSObjectName DATA_SOURCE = new PSObjectName("/DataSource");
    public static final PSObjectName BITS_PER_COMPONENT = new PSObjectName("/BitsPerComponent");
    public static final PSObjectName DECODE = new PSObjectName("/Decode");
    public static final PSObjectName INTERPOLATE = new PSObjectName("/Interpolate");
    public static final PSObjectName COLORSPACE = new PSObjectName("/ColorSpace");
    private static final int LL = 0;
    private static final int LR = 1;
    private static final int UR = 2;
    private static final int UL = 3;
    private int imgWidthPx;
    private int imgHeightPx;
    private int outputWidthPx;
    private int outputHeightPx;
    private double[] decode;
    private boolean interpolate;
    private PSObjectMatrix imageMatrix;
    private PSObjectMatrix ctm;
    private PSColor colorSpace;
    private int bitsPerComponent;
    private int bytesPerLine;
    private byte[] data;
    private double[][] imgBbox = new double[4][2];
    private double[][] deviceBbox = new double[4][2];
    private int[] cornerMap = new int[4];
    private double angle;
    private double[] vectorHor = new double[2];
    private double[] vectorVert = new double[2];

    public Image(PSObjectDict pSObjectDict, Interpreter interpreter, PSColor pSColor) throws PSError, ProgramError {
        try {
            this.ctm = interpreter.getGstate().current().getCtm().clone();
            this.colorSpace = pSColor.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProgramError("CloneNotSupported exception should not be thrown.");
        }
        int n = pSObjectDict.get(IMAGE_TYPE).toInt();
        try {
            switch (n) {
                case 1: {
                    this.loadType1Image(pSObjectDict, interpreter);
                    break;
                }
                case 3: {
                    throw new PSErrorUnimplemented("Bitmap images of type 3.");
                }
                case 4: {
                    throw new PSErrorUnimplemented("Bitmap images of type 4.");
                }
                default: {
                    throw new PSErrorRangeCheck();
                }
            }
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
    }

    private void loadType1Image(PSObjectDict pSObjectDict, Interpreter interpreter) throws PSError, ProgramError, IOException {
        int n;
        int n2;
        int n3;
        this.imgWidthPx = pSObjectDict.get(WIDTH).toInt();
        this.imgHeightPx = pSObjectDict.get(HEIGHT).toInt();
        int n4 = this.colorSpace.getNrInputValues();
        PSObjectArray pSObjectArray = pSObjectDict.get(DECODE).toArray();
        if (pSObjectArray.size() / 2 != n4) {
            throw new PSErrorRangeCheck();
        }
        this.decode = pSObjectArray.toDoubleArray();
        this.bitsPerComponent = pSObjectDict.get(BITS_PER_COMPONENT).toInt();
        this.imageMatrix = pSObjectDict.get(IMAGE_MATRIX).toMatrix();
        this.interpolate = pSObjectDict.known(INTERPOLATE) ? pSObjectDict.get(INTERPOLATE).toBool() : false;
        boolean bl = pSObjectDict.known(MULTIPLE_DATA_SOURCES) ? pSObjectDict.get(MULTIPLE_DATA_SOURCES).toBool() : false;
        PSObject pSObject = pSObjectDict.get(DATA_SOURCE);
        if (bl) {
            throw new PSErrorUnimplemented("Image from multiple data sources.");
        }
        if (pSObject instanceof PSObjectFile) {
            this.loadDataFromFile((PSObjectFile)pSObject, this.imgWidthPx, this.imgHeightPx, n4);
        } else {
            if (pSObject instanceof PSObjectString) {
                throw new PSErrorUnimplemented("Reading (bitmap) image data from a string.");
            }
            if (pSObject instanceof PSObjectArray) {
                if (bl) {
                    throw new PSErrorUnimplemented("Reading bitmap data from multiple data sources.");
                }
                this.loadDataFromProcedure((PSObjectArray)pSObject, this.imgWidthPx, this.imgHeightPx, n4, interpreter);
            } else {
                throw new PSErrorUnimplemented("Reading (bitmap) image data from other " + pSObject);
            }
        }
        this.imgBbox[0][0] = 0.0;
        this.imgBbox[0][1] = 0.0;
        this.imgBbox[1][0] = this.imgWidthPx;
        this.imgBbox[1][1] = 0.0;
        this.imgBbox[2][0] = this.imgWidthPx;
        this.imgBbox[2][1] = this.imgHeightPx;
        this.imgBbox[3][0] = 0.0;
        this.imgBbox[3][1] = this.imgHeightPx;
        this.deviceBbox[0] = this.ctm.transform(this.imageMatrix.itransform(this.imgBbox[0]));
        this.deviceBbox[1] = this.ctm.transform(this.imageMatrix.itransform(this.imgBbox[1]));
        this.deviceBbox[2] = this.ctm.transform(this.imageMatrix.itransform(this.imgBbox[2]));
        this.deviceBbox[3] = this.ctm.transform(this.imageMatrix.itransform(this.imgBbox[3]));
        int n5 = this.findNearest(-1.0E10, -1.0E10, this.deviceBbox, true);
        int n6 = (n5 - 1 + 4) % 4;
        int n7 = (n5 + 1) % 4;
        double d = this.deviceBbox[n6][0] - this.deviceBbox[n5][0];
        double d2 = this.deviceBbox[n6][1] - this.deviceBbox[n5][1];
        double d3 = this.deviceBbox[n7][0] - this.deviceBbox[n5][0];
        double d4 = this.deviceBbox[n7][1] - this.deviceBbox[n5][1];
        double d5 = Math.atan2(d2, d);
        double d6 = Math.atan2(d4, d3);
        if (Math.abs(d5) - Math.abs(d6) < 0.001) {
            this.angle = d5;
            n3 = n6;
            n2 = (n5 - 2 + 4) % 4;
            n = n7;
        } else {
            this.angle = d6;
            n3 = n7;
            n2 = (n5 + 2) % 4;
            n = n6;
        }
        this.cornerMap[0] = n5;
        this.cornerMap[1] = n3;
        this.cornerMap[2] = n2;
        this.cornerMap[3] = n;
        if (this.cornerMap[0] == 0 && this.cornerMap[1] == 1 || this.cornerMap[0] == 1 && this.cornerMap[1] == 0 || this.cornerMap[0] == 2 && this.cornerMap[1] == 3 || this.cornerMap[0] == 3 && this.cornerMap[1] == 2) {
            this.outputWidthPx = this.imgWidthPx;
            this.outputHeightPx = this.imgHeightPx;
        } else {
            this.outputWidthPx = this.imgHeightPx;
            this.outputHeightPx = this.imgWidthPx;
        }
        this.vectorHor[0] = (this.imgBbox[this.cornerMap[1]][0] - this.imgBbox[this.cornerMap[0]][0]) / (double)this.outputWidthPx;
        this.vectorHor[1] = (this.imgBbox[this.cornerMap[1]][1] - this.imgBbox[this.cornerMap[0]][1]) / (double)this.outputWidthPx;
        this.vectorVert[0] = (this.imgBbox[this.cornerMap[3]][0] - this.imgBbox[this.cornerMap[0]][0]) / (double)this.outputHeightPx;
        this.vectorVert[1] = (this.imgBbox[this.cornerMap[3]][1] - this.imgBbox[this.cornerMap[0]][1]) / (double)this.outputHeightPx;
    }

    private void loadDataFromFile(PSObjectFile pSObjectFile, int n, int n2, int n3) throws IOException, PSErrorRangeCheck {
        int n4;
        this.bytesPerLine = (int)Math.ceil((double)n * (double)n3 * (double)this.bitsPerComponent / 8.0);
        this.data = new byte[n2 * this.bytesPerLine];
        int n5 = 0;
        while ((n4 = pSObjectFile.getStream().read(this.data, n5, this.data.length - n5)) != 0) {
            n5 += n4;
        }
        if (n5 != n2 * this.bytesPerLine) {
            throw new PSErrorRangeCheck();
        }
    }

    private void loadDataFromProcedure(PSObjectArray pSObjectArray, int n, int n2, int n3, Interpreter interpreter) throws ProgramError, PSError {
        this.bytesPerLine = (int)Math.ceil((double)n * (double)n3 * (double)this.bitsPerComponent / 8.0);
        this.data = new byte[n2 * this.bytesPerLine];
        int n4 = 0;
        while (n4 < n2 * this.bytesPerLine) {
            interpreter.runObject(pSObjectArray);
            PSObjectString pSObjectString = interpreter.getOpStack().pop().toPSString();
            for (int i = 0; i < pSObjectString.length(); ++i) {
                this.data[n4] = (byte)pSObjectString.get(i);
                ++n4;
            }
        }
    }

    public void dumpInfo() throws PSError {
        System.out.println("Width: " + this.imgWidthPx + "px, height: " + this.imgHeightPx + "px");
        System.out.println("Image corners:");
        System.out.println("ll: (" + this.deviceBbox[0][0] / 1000.0 + " mm, " + this.deviceBbox[0][1] / 1000.0 + " mm)");
        System.out.println("lr: (" + this.deviceBbox[1][0] / 1000.0 + " mm, " + this.deviceBbox[1][1] / 1000.0 + " mm)");
        System.out.println("ur: (" + this.deviceBbox[2][0] / 1000.0 + " mm, " + this.deviceBbox[2][1] / 1000.0 + " mm)");
        System.out.println("ul: (" + this.deviceBbox[3][0] / 1000.0 + " mm, " + this.deviceBbox[3][1] / 1000.0 + " mm)");
        System.out.println("Device corners:");
        System.out.println("ll: (" + this.deviceBbox[this.cornerMap[0]][0] / 1000.0 + " mm, " + this.deviceBbox[this.cornerMap[0]][1] / 1000.0 + " mm)");
        System.out.println("lr: (" + this.deviceBbox[this.cornerMap[1]][0] / 1000.0 + " mm, " + this.deviceBbox[this.cornerMap[1]][1] / 1000.0 + " mm)");
        System.out.println("ur: (" + this.deviceBbox[this.cornerMap[2]][0] / 1000.0 + " mm, " + this.deviceBbox[this.cornerMap[2]][1] / 1000.0 + " mm)");
        System.out.println("ul: (" + this.deviceBbox[this.cornerMap[3]][0] / 1000.0 + " mm, " + this.deviceBbox[this.cornerMap[3]][1] / 1000.0 + " mm)");
        System.out.println("Angle: " + this.angle / Math.PI * 180.0);
        int[] nArray = new int[]{9, 0};
        int[] nArray2 = this.convertCoorDeviceToImg(nArray);
        System.out.println("Converting coordinate: (" + nArray[0] + ", " + nArray[1] + ") -> (" + nArray2[0] + ", " + nArray2[1] + ")");
    }

    private int findNearest(double d, double d2, double[][] dArray, boolean bl) {
        int n = -1;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = Math.abs(d - dArray[i][0]);
            double d7 = Math.abs(d2 - dArray[i][1]);
            double d8 = Math.sqrt(Math.pow(d6, 2.0) + Math.pow(d7, 2.0));
            boolean bl2 = false;
            if (Math.abs(d8 - d3) < 0.001) {
                if (bl && d7 < d5) {
                    bl2 = true;
                } else if (!bl && d6 < d4) {
                    bl2 = true;
                }
            } else if (d8 < d3) {
                bl2 = true;
            }
            if (!bl2) continue;
            d4 = d6;
            d5 = d7;
            d3 = d8;
            n = i;
        }
        return n;
    }

    private int[] convertCoorDeviceToImg(int[] nArray) throws PSError {
        double d = 0.5 + (double)nArray[0];
        double d2 = 0.5 + (double)nArray[1];
        double d3 = d * this.vectorHor[0] + d2 * this.vectorVert[0] + this.imgBbox[this.cornerMap[0]][0];
        double d4 = d * this.vectorHor[1] + d2 * this.vectorVert[1] + this.imgBbox[this.cornerMap[0]][1];
        int[] nArray2 = new int[]{(int)Math.round(d3 - 0.5), (int)Math.round(d4 - 0.5)};
        return nArray2;
    }

    public double getOutputWidthPt() {
        double d = this.deviceBbox[this.cornerMap[1]][0] - this.deviceBbox[this.cornerMap[0]][0];
        double d2 = this.deviceBbox[this.cornerMap[1]][1] - this.deviceBbox[this.cornerMap[0]][1];
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)) / 1000.0 / 25.4 * 72.0;
    }

    public double getOutputHeightPt() {
        double d = this.deviceBbox[this.cornerMap[3]][0] - this.deviceBbox[this.cornerMap[0]][0];
        double d2 = this.deviceBbox[this.cornerMap[3]][1] - this.deviceBbox[this.cornerMap[0]][1];
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)) / 1000.0 / 25.4 * 72.0;
    }

    public int getOutputWidthPx() {
        return this.outputWidthPx;
    }

    public int getOutputHeightPx() {
        return this.outputHeightPx;
    }

    public PSColor getColorSpace() {
        return this.colorSpace;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public double[] getDecode() {
        return (double[])this.decode.clone();
    }

    public boolean getInterpolate() {
        return this.interpolate;
    }

    public double[] getPixelInputValues(int n, int n2) throws PSError {
        int[] nArray = this.getPixelInputIntValues(n, n2);
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            double d = this.decode[2 * i];
            double d2 = this.decode[2 * i + 1];
            dArray[i] = d + (double)nArray[i] * (d2 - d) / (Math.pow(2.0, this.bitsPerComponent) - 1.0);
        }
        return dArray;
    }

    public int[] getPixelInputIntValues(int n, int n2) throws PSError {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = this.convertCoorDeviceToImg(nArray);
        int n3 = this.colorSpace.getNrInputValues();
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6 = 8 * this.bytesPerLine * nArray2[1] + this.bitsPerComponent * n3 * nArray2[0] + i * this.bitsPerComponent;
            int n7 = n6 + this.bitsPerComponent - 1;
            int n8 = n6 / 8;
            int n9 = 7 - n6 % 8;
            int n10 = n7 / 8;
            int n11 = 7 - n7 % 8;
            if (n8 == n10) {
                n5 = (1 << n9 + 1) - 1 ^ (1 << n11) - 1;
                n4 = (this.data[n8] & n5) >> n11;
            } else if (n8 == n10 - 1) {
                n5 = (1 << n9 + 1) - 1;
                int n12 = 0xFF ^ (1 << n11) - 1;
                n4 = (this.data[n8] & n5) << 8 - n11;
                n4 |= (this.data[n10] & n12) >> n11;
            } else {
                throw new PSErrorUnimplemented("More than 16 bit per component is not supported in bitmap images.");
            }
            nArray3[i] = n4;
        }
        return nArray3;
    }

    public double[][] getDeviceBbox() {
        return (double[][])this.deviceBbox.clone();
    }

    public int[] getCornerMap() {
        return (int[])this.cornerMap.clone();
    }

    public double getAngle() {
        return this.angle / Math.PI * 180.0;
    }
}

