/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class RandomAccessOutputStream
extends ByteArrayOutputStream {
    private OutputStream targetOut;
    private int maxCount;

    public RandomAccessOutputStream(OutputStream outputStream) {
        this.targetOut = outputStream;
    }

    public void close() throws IOException {
        super.writeTo(this.targetOut);
    }

    public int getPointer() {
        return this.count;
    }

    public void seek(int n) throws IOException {
        if (n < 0 || n > this.maxCount) {
            throw new IOException();
        }
        this.count = n;
    }

    public int size() {
        return this.maxCount;
    }

    public void reset() {
        super.reset();
        this.maxCount = 0;
    }

    public void write(byte[] byArray, int n, int n2) {
        super.write(byArray, n, n2);
        this.maxCount = Math.max(this.count, this.maxCount);
    }

    public void write(int n) {
        super.write(n);
        this.maxCount = Math.max(this.count, this.maxCount);
    }

    public void write(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes("US-ASCII");
            this.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("System does not support US-ASCII charset.");
        }
    }

    public byte[] toByteArray() {
        int n = this.count;
        this.count = this.maxCount;
        byte[] byArray = super.toByteArray();
        this.count = n;
        return byArray;
    }

    public String toString() {
        int n = this.count;
        this.count = this.maxCount;
        String string = super.toString();
        this.count = n;
        return string;
    }

    public String toString(String string) throws UnsupportedEncodingException {
        int n = this.count;
        this.count = this.maxCount;
        String string2 = super.toString(string);
        this.count = n;
        return string2;
    }

    public void flush() throws IOException {
    }
}

