/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.io.IOException;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.GraphicsState;
import net.sf.eps2pgf.ps.errors.PSErrorStackUnderflow;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;
import net.sf.eps2pgf.util.ArrayStack;

public class GstateStack {
    private ArrayStack<GraphicsState> stack = new ArrayStack();
    private GraphicsState current;

    public GstateStack(OutputDevice outputDevice) {
        this.setCurrent(new GraphicsState(this, outputDevice));
    }

    public void saveGstate() throws ProgramError, IOException {
        try {
            this.stack.push(this.current().clone());
            this.current().getDevice().startScope();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProgramError("Clone method not yet implemented.");
        }
    }

    public void restoreGstate() throws ProgramError, IOException {
        if (this.stack.isEmpty()) {
            return;
        }
        try {
            this.setCurrent(this.stack.pop());
            this.current().getDevice().endScope();
        }
        catch (PSErrorStackUnderflow pSErrorStackUnderflow) {
            ProgramError programError = new ProgramError("Stack underflow shouldn't happen here.");
            programError.initCause(pSErrorStackUnderflow);
            throw programError;
        }
    }

    private void setCurrent(GraphicsState graphicsState) {
        this.current = graphicsState;
    }

    public GraphicsState current() {
        return this.current;
    }
}

