/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedSectionInputStream
extends InputStream {
    private InputStream rdr;
    private int length;
    private int charsRead = 0;
    private int lastMark = -1;

    public LimitedSectionInputStream(InputStream inputStream, int n, int n2) throws IOException {
        this.length = n2;
        this.rdr = inputStream;
        long l = this.rdr.skip(n);
        if (l != (long)n) {
            throw new IOException("Unable to skip the requested number of characters (" + n + ").");
        }
    }

    public void close() throws IOException {
        this.rdr.close();
    }

    public void mark(int n) {
        this.rdr.mark(n);
        this.lastMark = this.charsRead;
    }

    public boolean markSupported() {
        return this.rdr.markSupported();
    }

    public int read() throws IOException {
        if (this.charsRead >= this.length) {
            return -1;
        }
        ++this.charsRead;
        return this.rdr.read();
    }

    public int read(byte[] byArray) throws IOException {
        int n = Math.min(this.length - this.charsRead, byArray.length);
        int n2 = this.rdr.read(byArray, 0, n);
        if (n2 > 0) {
            this.charsRead += n2;
        } else {
            n2 = -1;
        }
        return n2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.length - this.charsRead, n2);
        int n4 = this.rdr.read(byArray, 0, n3);
        if (n4 > 0) {
            this.charsRead += n4;
        } else {
            n4 = -1;
        }
        return n4;
    }

    public void reset() throws IOException {
        this.charsRead = this.lastMark;
        this.rdr.reset();
    }

    public long skip(long l) throws IOException {
        long l2 = this.rdr.skip(l);
        this.charsRead = (int)((long)this.charsRead + l2);
        return l2;
    }
}

