% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posttestOddsProbability.R
\name{posttestOdds}
\alias{posttestOdds}
\alias{posttestProbability}
\title{Posttest Odds & Probability.}
\usage{
posttestOdds(
  TP,
  TN,
  FP,
  FN,
  pretestProb = NULL,
  SN = NULL,
  SP = NULL,
  likelihoodRatio = NULL
)

posttestProbability(
  TP,
  TN,
  FP,
  FN,
  pretestProb = NULL,
  SN = NULL,
  SP = NULL,
  likelihoodRatio = NULL
)
}
\arguments{
\item{TP}{Number of true positive cases.}

\item{TN}{Number of true negative cases.}

\item{FP}{Number of false positive cases.}

\item{FN}{Number of false negative cases.}

\item{pretestProb}{Pretest probability (prevalence/base rate/prior
probability) of characteristic, as a number between 0 and 1.}

\item{SN}{Sensitivity of the test at a given cut point, as a number
between 0 and 1.}

\item{SP}{Specificity of the test at a given cut point, as a number
between 0 and 1.}

\item{likelihoodRatio}{Likelihood ratio of the test at a given cut point.}
}
\value{
The requested posttest odds or pottest probability.
}
\description{
Estimate posttest odds and posttest probability.
}
\details{
Estimates posttest odds or posttest probability.
}
\examples{
posttestOdds(
  TP = 26,
  TN = 56,
  FP = 14,
  FN = 14)

posttestOdds(
  pretestProb = 0.3636364,
  SN = 0.65,
  SP = 0.80)

posttestOdds(
  pretestProb = 0.3636364,
  likelihoodRatio = 3.25)

posttestProbability(
  TP = 26,
  TN = 56,
  FP = 14,
  FN = 14)

posttestProbability(
  pretestProb = 0.3636364,
  SN = 0.65,
  SP = 0.80)

posttestProbability(
  pretestProb = 0.3636364,
  likelihoodRatio = 3.25)
}
\seealso{
Other accuracy: 
\code{\link{accuracyAtCutoff}()},
\code{\link{accuracyAtEachCutoff}()},
\code{\link{accuracyOverall}()},
\code{\link{nomogrammer}()},
\code{\link{optimalCutoff}()}
}
\concept{accuracy}
