% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield_while.R
\name{yield_while}
\alias{yield_while}
\title{yield_while}
\usage{
yield_while(iter, cond)
}
\arguments{
\item{iter}{An \code{Iterator} object}

\item{cond}{A quoted logical expression involving some variable(s) in \code{iter$initial}, so that \code{yield_next()}
continues being called while the expression returns TRUE}
}
\description{
Keep yielding the next element of an \code{Iterator} while a condition is met.
A condition is some function involving any variable(s) in the \code{Iterator} environment
}
\examples{
expr <- "if (n \%\% 2 == 0) n <- n / 2 else n <- n*3 + 1"
collatz <- Iterator(result = expr,
                    initial = c(n = 50),
                    yield = n)
yield_while(collatz, "n != 1L")

}
