% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate.perry}
\alias{aggregate.perry}
\alias{aggregate.perrySelect}
\alias{aggregate.perryTuning}
\title{Aggregate resampling-based prediction error results}
\usage{
\method{aggregate}{perry}(x, FUN = mean, select = NULL, ...)

\method{aggregate}{perrySelect}(x, FUN = mean, select = NULL, ...)

\method{aggregate}{perryTuning}(x, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{"perry"} or
\code{"perrySelect"} that contains prediction error results (note that the
latter includes objects of class \code{"perryTuning"}).}

\item{FUN}{a function to compute the summary statistics.}

\item{select}{a character, integer or logical vector indicating the columns
of prediction error results for which to compute the summary statistics.}

\item{\dots}{for the \code{"perryTuning"} method, additional arguments to
be passed to the \code{"perrySelect"} method.  Otherwise additional
arguments to be passed to \code{FUN}.}
}
\value{
The \code{"perry"} method returns a vector or matrix of aggregated
prediction error results, depending on whether \code{FUN} returns a single
value or a vector.

For the other methods, a data frame containing the aggregated
prediction error results for each model is returned.  In the case of the
\code{"perryTuning"} method, the data frame contains the combinations of
tuning parameters rather than a column describing the models.
}
\description{
Compute summary statistics of resampling-based prediction error results.
}
\note{
Duplicate indices in \code{subset} or \code{select} are removed such
that all models and prediction error results are unique.
}
\seealso{
\code{\link{perryFit}}, \code{\link{perrySelect}},
\code{\link{perryTuning}}, \code{\link[stats]{aggregate}}
}
\author{
Andreas Alfons
}
\keyword{utilities}
