\name{perrySplits}
\alias{perrySplits}
\title{Data splits for resampling-based prediction error measures}
\usage{
  perrySplits(n, control)
}
\arguments{
  \item{n}{an integer giving the number of observations to
  be split.}

  \item{control}{a control object of class
  \code{"foldControl"} (as generated by
  \code{\link{foldControl}}), \code{"splitControl"} (as
  generated by \code{\link{splitControl}}) or
  \code{"bootControl"} (as generated by
  \code{\link{bootControl}}).}
}
\value{
  For the \code{foldControl} method, an object of class
  \code{"cvFolds"} giving folds for (repeated) \eqn{K}-fold
  cross-validation (see \code{\link{cvFolds}}).

  For the \code{splitControl} method, an object of class
  \code{"randomSplits"} giving random data splits (see
  \code{\link{randomSplits}}).

  For the \code{bootControl} method, an object of class
  \code{"bootSamples"} giving bootstrap samples (see
  \code{\link{bootSamples}}).
}
\description{
  Split observations or groups of observations into
  segments to be used for (repeated) \eqn{K}-fold
  cross-validation, (repeated) random splitting (also known
  as random subsampling or Monte Carlo cross-validation),
  or the bootstrap.
}
\note{
  Users may prefer the wrapper functions
  \code{\link{cvFolds}}, \code{\link{randomSplits}} and
  \code{\link{bootSamples}}.
}
\examples{
set.seed(1234)  # set seed for reproducibility

## data folds for K-fold cross-validation
perrySplits(20, foldControl(K = 5))
perrySplits(20, foldControl(K = 5, R = 10))

## random data splits
perrySplits(20, splitControl(m = 5))
perrySplits(20, splitControl(m = 5, R = 10))

## bootstrap samples
perrySplits(20, bootControl())
perrySplits(20, bootControl(R = 10))
}
\author{
  Andreas Alfons
}
\seealso{
  \code{\link{foldControl}}, \code{\link{splitControl}},
  \code{\link{bootControl}}, \code{\link{cvFolds}},
  \code{\link{randomSplits}}, \code{\link{bootSamples}}
}
\keyword{utilities}

