% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permLR.R
\name{createPermGS}
\alias{createPermGS}
\title{createPermGS}
\usage{
createPermGS(B = 1000, restricted = TRUE, method = "IPZ", pool = TRUE,
  type = c("logrank", "Gehan-Breslow", "Tarone-Ware", "Prentice",
  "Prentice-Marek", "Andersen-Borgan-Gill-Keiding", "Fleming-Harrington",
  "Self"), imputeData = NULL, permuteData = NULL)
}
\arguments{
\item{B}{number of random permutations}

\item{restricted}{if TRUE only permute within strata}

\item{method}{imputation/permuation method IPZ, IPT, Heinze or none (default: IPZ)}

\item{pool}{if TRUE impute event times from Kaplan-Meier estimator calculated from pooled data}

\item{type}{logrank weights to be used with coin::logrank_trafo}

\item{imputeData}{user-supplied imputation function (ignored if method is given)}

\item{permuteData}{user-supplied permutation function (ignore if method is given)}
}
\value{
object of class permGS
}
\description{
Create permGS object representing a permutational group-sequential trial.
}
\examples{
## standard permutation test (no imputation, free permutations)
x <- createPermGS(1000, FALSE, "none")
summary(x)
## imputation using IPT method, restricted permutations
y <- createPermGS(1000, TRUE, "IPT")
summary(y)
}

