% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{ui_tooltip}
\alias{ui_tooltip}
\title{Add tooltip icon and text to UI elements labels}
\usage{
ui_tooltip(id, label = "", text = "", placement = "top")
}
\arguments{
\item{id}{- The id for the tooltip object}

\item{label}{- Text label to appear to the left of the tooltip image}

\item{text}{- Tooltip text shown when the user hovers over the image}

\item{placement}{- Where to display tooltip label. Available places are "top", "bottom", "left", "right" (default is "top")}
}
\value{
html span with the label, tooltip image and tooltip text
}
\description{
This function inserts a standardized tooltip image, label (optional),
and hovertext into the application UI
}
\section{Shiny Usage}{

Call this function from \code{program/ui_body.R} to set tooltip parameters
}

\examples{
  library(shiny)
  library(periscope2)

  # Inside ui_body.R or similar UI file
   ui_tooltip(id   = "top_tip",
             label = "Top Tooltips",
             text  = "Top tooltip")

}
\seealso{
\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
