% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_model.R
\name{check_model}
\alias{check_model}
\alias{check_model.default}
\title{Visual check of model assumptions}
\usage{
check_model(x, ...)

\method{check_model}{default}(
  x,
  dot_size = 2,
  line_size = 0.8,
  panel = TRUE,
  check = "all",
  alpha = 0.2,
  ...
)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{dot_size}{Size of dot-geoms.}

\item{line_size}{Size of line-geoms.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else,
single plots for each diagnostic are returned.}

\item{check}{Character vector, indicating which checks for should be performed
and plotted. May be one or more of
\code{"all", "vif", "qq", "normality", "ncv", "homogeneity", "outliers", "reqq"}.
\code{"reqq"} is a QQ-plot for random effects and only available for mixed models.
\code{"ncv"} checks for non-constant variance, i.e. for heteroscedasticity.
By default, all possible checks are performed and plotted.}

\item{alpha}{The alpha level of the confidence bands. Scalar from 0 to 1.}
}
\value{
The data frame that is used for plotting.
}
\description{
Visual check of model various assumptions (normality of residuals,
normality of random effects, heteroscedasticity, homogeneity of variance,
multicollinearity).
}
\note{
This function just prepares the data for plotting. To create the plots,
\CRANpkg{see} needs to be installed. Furthermore, this function suppresses
all possible warnings. In case you observe suspicious plots, please refer to
the dedicated functions (like \code{check_collinearity()}, \code{check_normality()}
etc.) to get informative messages and warnings.
}
\examples{
\dontrun{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_model(m)

if (require("lme4")) {
  m <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
  check_model(m, panel = FALSE)
}

if (require("rstanarm")) {
  m <- stan_glm(mpg ~ wt + gear, data = mtcars, chains = 2, iter = 200)
  check_model(m)
}
}
}
