% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hosmer_lemeshow.R
\name{hosmer_lemeshow}
\alias{hosmer_lemeshow}
\title{Hosmer-Lemeshow goodness-of-fit test}
\usage{
hosmer_lemeshow(model, n_bins = 10)
}
\arguments{
\item{model}{A \code{glm}-object with binomial-family.}

\item{n_bins}{Numeric, the number of bins to divide the data.}
}
\value{
An object of class \code{hoslem_test} with following values: \code{chisq},
  the Hosmer-Lemeshow chi-squared statistic; \code{df}, degrees of freedom
  and \code{p.value} the p-value for the goodness-of-fit test.
}
\description{
Check model quality of logistic regression models.
}
\details{
A well-fitting model shows \emph{no} significant difference between
  the model and the observed data, i.e. the reported p-value should be
  greater than 0.05.
}
\examples{
model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
hosmer_lemeshow(model)

}
\references{
Hosmer, D. W., & Lemeshow, S. (2000). Applied Logistic Regression. Hoboken, NJ, USA: John Wiley & Sons, Inc. \doi{10.1002/0471722146}
}
