% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{en_algorithm_options}
\alias{en_algorithm_options}
\title{Control the Algorithm to Compute (Weighted) Least-Squares Elastic Net Estimates}
\description{
The package supports different algorithms to compute the EN estimate for weighted LS loss functions.
Each algorithm has certain characteristics that make it useful for some problems.
To select a specific algorithm and adjust the options, use any of the \verb{en_***_options} functions.
}
\details{
\itemize{
\item \code{\link[=en_lars_options]{en_lars_options()}}: Use the tuning-free LARS algorithm. This computes \emph{exact} (up to numerical errors) solutions
to the EN-LS problem. It is not iterative and therefore can not benefit from approximate
solutions, but in turn guarantees that a solution will be found.
\item \code{\link[=en_admm_options]{en_admm_options()}}: Use an iterative ADMM-type algorithm which needs \eqn{O(n p)} operations per iteration and
converges sub-linearly.
\item \code{\link[=en_dal_options]{en_dal_options()}}: Use the iterative Dual Augmented Lagrangian (DAL) method. DAL needs \eqn{O(n^3 p^2)} operations
per iteration, but converges exponentially.
}
}
