% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collinearity_check}
\alias{collinearity_check}
\title{Checking for Perfect Multicollinearity}
\usage{
collinearity_check(
  y,
  x = NULL,
  fes = NULL,
  hdfetol,
  colcheck_x_fes = FALSE,
  colcheck_x = FALSE
)
}
\arguments{
\item{y}{Dependent variable (a numeric vector).}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{hdfetol}{Tolerance for the centering, passed on to \code{lfe::demeanlist}.}

\item{colcheck_x_fes}{Logical. If \code{TRUE}, this checks whether the independent variables are perfectly explained
by the fixed effects drops those that are perfectly explained.}

\item{colcheck_x}{Logical. If \code{TRUE}, this checks collinearity between the independent variables and drops the
collinear variables.}
}
\value{
A numeric vector containing the variables that pass the collinearity check.
}
\description{
\code{collinearity_check} checks for perfect multicollinearity in a model with high-dimensional
fixed effects. It calls \code{lfe::demeanlist} in order to partial out the fixed effects, and then
uses \code{stats::lm.wfit} to discard linearly dependent variables.
}
