% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{penfaParEstim}
\alias{penfaParEstim}
\title{Print parameter estimates in table format}
\usage{
penfaParEstim(
  object,
  se = TRUE,
  ci = TRUE,
  level = 0.95,
  remove.nonfree = FALSE,
  output = "data.frame",
  header = FALSE
)
}
\arguments{
\item{object}{An object of class \code{\linkS4class{penfa}}.}

\item{se}{Logical. If \code{TRUE}, it includes a column with the standard
errors.}

\item{ci}{Logical. If \code{TRUE}, the confidence intervals are added to the
output.}

\item{level}{The confidence level, default is 0.95.}

\item{remove.nonfree}{Logical. If \code{TRUE}, it filters the output and
removes all rows with fixed (that is, neither free, nor penalized)
parameters.}

\item{output}{Character. If "data.frame", the parameter table is displayed as
a standard formatted data.frame. If "text", the parameter table is
displayed with subsections (as used by the \code{summary} function).}

\item{header}{Logical, only used if \code{output = "text"}. If \code{TRUE},
it prints a header on top of the parameter list with details on the group
levels and the information matrix used during optimization by the
trust-region algorithm.}
}
\value{
A dataframe of class \code{penfa.data.frame} with the parameter
estimates of a \code{penfa} model for each group.
}
\description{
The parameter estimates of the penalized factor analysis model
in each group.
}
\examples{

data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

penfaParEstim(alasso_fit)

}
\seealso{
\code{\link{penfa}}
}
