% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_convert.R
\name{as.ped}
\alias{as.ped}
\alias{as.ped.data.frame}
\title{Conversions to ped objects}
\usage{
as.ped(x, ...)

\method{as.ped}{data.frame}(
  x,
  famid_col = NA,
  id_col = NA,
  fid_col = NA,
  mid_col = NA,
  sex_col = NA,
  marker_col = NA,
  locusAttributes = NULL,
  missing = 0,
  sep = NULL,
  validate = TRUE,
  ...
)
}
\arguments{
\item{x}{Any object.}

\item{...}{Not used.}

\item{famid_col}{Index of family ID column. If NA, the program looks for a
column named "famid" (ignoring case).}

\item{id_col}{Index of individual ID column. If NA, the program looks for a
column named "id" (ignoring case).}

\item{fid_col}{Index of father ID column. If NA, the program looks for a
column named "fid" (ignoring case).}

\item{mid_col}{Index of mother ID column. If NA, the program looks for a
column named "mid" (ignoring case).}

\item{sex_col}{Index of column with gender codes (0 = unknown; 1 = male; 2 =
female). If NA, the program looks for a column named "sex" (ignoring case).
If this is not found, genders of parents are deduced from the data, leaving
the remaining as unknown.}

\item{marker_col}{Index vector indicating columns with marker alleles. If NA,
all columns to the right of all pedigree columns are used. If \code{sep}
(see below) is non-NULL, each column is interpreted as a genotype column
and split into separate alleles with \code{strsplit(..., split = sep, fixed = TRUE)}.}

\item{locusAttributes}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{missing}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{sep}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{validate}{A logical indicating if the pedigree structure should be validated.}
}
\value{
A \code{ped} object or a list of such.
}
\description{
Conversions to ped objects
}
\examples{
df = data.frame(famid = c("S1", "S2"),
                id = c("A", "B"),
                fid = 0,
                mid = 0,
                sex = 1)

# gives a list of two singletons
as.ped(df)

# Trio
df1 = data.frame(id = 1:3, fid = c(0,0,1), mid = c(0,0,2), sex = c(1,2,1))
as.ped(df1)

# Disconnected example: Trio (1-3) + singleton (4)
df2 = data.frame(id = 1:4, fid = c(2,0,0,0), mid = c(3,0,0,0),
                M = c("1/2", "1/1", "2/2", "3/4"))
as.ped(df2, sep = "/")

# Two singletons
df3 = data.frame(id = 1:2, fid = 0, mid = 0, sex = 1)
as.ped(df3)

}
